//! `SeaORM` Entity, @generated by sea-orm-codegen 1.1.12

use sea_orm::entity::prelude::*;

use crate::database::enums::{Assignment, RecipientTypeFull};

#[derive(Copy, Clone, Default, Debug, DeriveEntity)]
pub struct Entity;

impl EntityName for Entity {
    fn table_name(&self) -> &str {
        "transfer"
    }
}

#[derive(Clone, Debug, PartialEq, DeriveModel, DeriveActiveModel, Eq)]
pub struct Model {
    pub idx: i32,
    pub asset_transfer_idx: i32,
    pub requested_assignment: Option<Assignment>,
    pub incoming: bool,
    pub recipient_type: Option<RecipientTypeFull>,
    pub recipient_id: Option<String>,
    pub ack: Option<bool>,
    pub invoice_string: Option<String>,
}

#[derive(Copy, Clone, Debug, EnumIter, DeriveColumn)]
pub enum Column {
    Idx,
    AssetTransferIdx,
    RequestedAssignment,
    Incoming,
    RecipientType,
    RecipientId,
    Ack,
    InvoiceString,
}

#[derive(Copy, Clone, Debug, EnumIter, DerivePrimaryKey)]
pub enum PrimaryKey {
    Idx,
}

impl PrimaryKeyTrait for PrimaryKey {
    type ValueType = i32;
    fn auto_increment() -> bool {
        true
    }
}

#[derive(Copy, Clone, Debug, EnumIter)]
pub enum Relation {
    AssetTransfer,
    TransferTransportEndpoint,
}

impl ColumnTrait for Column {
    type EntityName = Entity;
    fn def(&self) -> ColumnDef {
        match self {
            Self::Idx => ColumnType::Integer.def(),
            Self::AssetTransferIdx => ColumnType::Integer.def(),
            Self::RequestedAssignment => ColumnType::Json.def().null(),
            Self::Incoming => ColumnType::Boolean.def(),
            Self::RecipientType => ColumnType::Json.def().null(),
            Self::RecipientId => ColumnType::String(StringLen::None).def().null(),
            Self::Ack => ColumnType::Boolean.def().null(),
            Self::InvoiceString => ColumnType::String(StringLen::None).def().null(),
        }
    }
}

impl RelationTrait for Relation {
    fn def(&self) -> RelationDef {
        match self {
            Self::AssetTransfer => Entity::belongs_to(super::asset_transfer::Entity)
                .from(Column::AssetTransferIdx)
                .to(super::asset_transfer::Column::Idx)
                .into(),
            Self::TransferTransportEndpoint => {
                Entity::has_many(super::transfer_transport_endpoint::Entity).into()
            }
        }
    }
}

impl Related<super::asset_transfer::Entity> for Entity {
    fn to() -> RelationDef {
        Relation::AssetTransfer.def()
    }
}

impl Related<super::transfer_transport_endpoint::Entity> for Entity {
    fn to() -> RelationDef {
        Relation::TransferTransportEndpoint.def()
    }
}

impl ActiveModelBehavior for ActiveModel {}
