//! `SeaORM` Entity, @generated by sea-orm-codegen 1.1.12

use sea_orm::entity::prelude::*;

#[derive(Copy, Clone, Default, Debug, DeriveEntity)]
pub struct Entity;

impl EntityName for Entity {
    fn table_name(&self) -> &str {
        "transfer_transport_endpoint"
    }
}

#[derive(Clone, Debug, PartialEq, DeriveModel, DeriveActiveModel, Eq)]
pub struct Model {
    pub idx: i32,
    pub transfer_idx: i32,
    pub transport_endpoint_idx: i32,
    pub used: bool,
}

#[derive(Copy, Clone, Debug, EnumIter, DeriveColumn)]
pub enum Column {
    Idx,
    TransferIdx,
    TransportEndpointIdx,
    Used,
}

#[derive(Copy, Clone, Debug, EnumIter, DerivePrimaryKey)]
pub enum PrimaryKey {
    Idx,
}

impl PrimaryKeyTrait for PrimaryKey {
    type ValueType = i32;
    fn auto_increment() -> bool {
        true
    }
}

#[derive(Copy, Clone, Debug, EnumIter)]
pub enum Relation {
    Transfer,
    TransportEndpoint,
}

impl ColumnTrait for Column {
    type EntityName = Entity;
    fn def(&self) -> ColumnDef {
        match self {
            Self::Idx => ColumnType::Integer.def(),
            Self::TransferIdx => ColumnType::Integer.def(),
            Self::TransportEndpointIdx => ColumnType::Integer.def(),
            Self::Used => ColumnType::Boolean.def(),
        }
    }
}

impl RelationTrait for Relation {
    fn def(&self) -> RelationDef {
        match self {
            Self::Transfer => Entity::belongs_to(super::transfer::Entity)
                .from(Column::TransferIdx)
                .to(super::transfer::Column::Idx)
                .into(),
            Self::TransportEndpoint => Entity::belongs_to(super::transport_endpoint::Entity)
                .from(Column::TransportEndpointIdx)
                .to(super::transport_endpoint::Column::Idx)
                .into(),
        }
    }
}

impl Related<super::transfer::Entity> for Entity {
    fn to() -> RelationDef {
        Relation::Transfer.def()
    }
}

impl Related<super::transport_endpoint::Entity> for Entity {
    fn to() -> RelationDef {
        Relation::TransportEndpoint.def()
    }
}

impl ActiveModelBehavior for ActiveModel {}
