//! `SeaORM` Entity, @generated by sea-orm-codegen 1.1.12

use sea_orm::entity::prelude::*;

use crate::database::TransportType;

#[derive(Copy, Clone, Default, Debug, DeriveEntity)]
pub struct Entity;

impl EntityName for Entity {
    fn table_name(&self) -> &str {
        "transport_endpoint"
    }
}

#[derive(Clone, Debug, PartialEq, DeriveModel, DeriveActiveModel, Eq)]
pub struct Model {
    pub idx: i32,
    pub transport_type: TransportType,
    pub endpoint: String,
}

#[derive(Copy, Clone, Debug, EnumIter, DeriveColumn)]
pub enum Column {
    Idx,
    TransportType,
    Endpoint,
}

#[derive(Copy, Clone, Debug, EnumIter, DerivePrimaryKey)]
pub enum PrimaryKey {
    Idx,
}

impl PrimaryKeyTrait for PrimaryKey {
    type ValueType = i32;
    fn auto_increment() -> bool {
        true
    }
}

#[derive(Copy, Clone, Debug, EnumIter)]
pub enum Relation {
    TransferTransportEndpoint,
}

impl ColumnTrait for Column {
    type EntityName = Entity;
    fn def(&self) -> ColumnDef {
        match self {
            Self::Idx => ColumnType::Integer.def(),
            Self::TransportType => ColumnType::SmallInteger.def(),
            Self::Endpoint => ColumnType::String(StringLen::None).def(),
        }
    }
}

impl RelationTrait for Relation {
    fn def(&self) -> RelationDef {
        match self {
            Self::TransferTransportEndpoint => {
                Entity::has_many(super::transfer_transport_endpoint::Entity).into()
            }
        }
    }
}

impl Related<super::transfer_transport_endpoint::Entity> for Entity {
    fn to() -> RelationDef {
        Relation::TransferTransportEndpoint.def()
    }
}

impl ActiveModelBehavior for ActiveModel {}
