## Description

<!-- Provide a clear and concise description of your changes -->

Fixes #(issue)

## Type of Change

<!-- Mark the relevant option with an "x" -->

- [ ] 🐛 Bug fix (non-breaking change which fixes an issue)
- [ ] ✨ New feature (non-breaking change which adds functionality)
- [ ] 💥 Breaking change (fix or feature that would cause existing functionality to not work as expected)
- [ ] 📝 Documentation update
- [ ] 🔧 Configuration/build change
- [ ] ♻️ Refactoring (no functional changes)
- [ ] ✅ Test addition or update
- [ ] 🎨 UI/Template improvement

## Changes Made

<!-- List the specific changes in this PR -->

-
-
-

## Testing Performed

<!-- Describe the testing you've done -->

### Manual Testing

- [ ] Tested with Specify CLI (`specify init`, `specify check`)
- [ ] Tested with AI agent(s): <!-- specify which: Copilot, Claude, Cursor, etc. -->
- [ ] Tested commands: <!-- e.g., /plan, /spec, /phr, /adr -->
- [ ] Tested on OS: <!-- macOS, Linux, Windows -->

### Test Scenarios

<!-- Describe specific test cases -->

1.
2.
3.

### Expected Results

<!-- What should happen? -->

### Actual Results

<!-- What actually happened? -->

## Impact Assessment

<!-- Help reviewers understand the scope of your changes -->

### Components Affected

- [ ] Specify CLI commands
- [ ] PHR automation
- [ ] ADR automation
- [ ] Agent commands (/.commands)
- [ ] Templates (spec, plan, tasks, etc.)
- [ ] Build/release scripts
- [ ] Documentation
- [ ] AGENTS.md protocol
- [ ] command-rules.md
- [ ] Other: <!-- specify -->

### Backward Compatibility

- [ ] ✅ Fully backward compatible
- [ ] ⚠️ Requires migration (see migration guide below)
- [ ] 💥 Breaking change (see breaking changes section below)

<!-- If breaking or requires migration, explain: -->

### Migration Guide

<!-- How should users update existing projects? -->

### Breaking Changes

<!-- What will break? How should users adapt? -->

## Documentation

<!-- Ensure documentation is updated -->

- [ ] Updated README.md (if user-facing changes)
- [ ] Updated relevant docs/ files
- [ ] Updated AGENTS.md (if protocol changes)
- [ ] Updated command-rules.md (if automation changes)
- [ ] Updated templates (if template changes)
- [ ] Updated CHANGELOG.md
- [ ] Added inline code comments (for complex logic)
- [ ] No documentation needed

## Code Quality

<!-- Ensure code quality standards -->

- [ ] Code follows project style guidelines
- [ ] Self-review performed
- [ ] No new warnings or errors
- [ ] Commented complex or non-obvious code
- [ ] No hardcoded values (using config where appropriate)

## Release Notes

<!-- What should appear in the release notes? -->

**User-Facing Changes:**

-

**Developer-Facing Changes:**

-

**Fixes:**

-

## Checklist

<!-- Final checks before requesting review -->

- [ ] Branch is up to date with base branch
- [ ] All commits have clear, descriptive messages
- [ ] No unrelated changes included
- [ ] Ready for review

## Additional Context

<!-- Any other context, screenshots, or information -->

## Reviewer Notes

<!-- Specific areas you'd like reviewers to focus on -->

---

**For Reviewers:**

### Review Checklist

- [ ] Code changes are clear and appropriate
- [ ] Tests cover the changes adequately
- [ ] Documentation is complete and accurate
- [ ] No security concerns
- [ ] Breaking changes are well-justified and documented
- [ ] Performance impact is acceptable

### Testing Checklist

- [ ] Pulled branch and tested locally
- [ ] Verified manual test scenarios
- [ ] Tested with relevant AI agent(s)
- [ ] No regressions observed
