# Complete AI CLI Tutorial: Gemini, Qwen & Claude Code

- For students: Gemini CLI + Qwen Code (free)
- For professionals: Claude Code ($20) + Cursor ($20) → $40/month
---

### What Are Terminal-Based AI Assistants?

Terminal-based AI coding assistants bring the power of Large Language Models (LLMs) directly into your command line, allowing you to:
- Generate code without leaving the terminal
- Get bash commands and git operations on demand
- Debug issues by asking questions
- Write documentation and specifications
- Learn shell commands with explanations
- Refactor and optimize code
- Execute complex command pipelines safely

### Why Use Terminal AI Assistants?

**Advantages:**
- **Speed**: No context switching between browser and terminal
- **Integration**: Works with your existing terminal workflow
- **Command Generation**: Instantly get bash, git, and system commands
- **Privacy**: Some can run locally (Qwen Code)
- **Efficiency**: Pipe output to files, chain commands
- **Learning**: Understand commands with AI explanations
- **Focus**: Stay in flow state without distractions

### Tool Comparison Overview

| Feature | Gemini CLI | Qwen Code | Claude Code |
|---------|------------|-----------|-------------|
| **Cost** | Free (generous) | Free (local) | $20/month |
| **Quality** | Excellent | Very Good | Best |
| **Speed** | Fast | Very Fast | Fast |
| **Context** | Large | Medium | Very Large |
| **Best For** | Specs, PRDs, Debugging | Coding (free) | Professional Coding |
| **Offline** | No | Yes | No |
| **Model** | Gemini 2.5 Pro | Qwen 3 Coder | Claude Sonnet 4.5 |
| **Bash/Git Help** | Excellent | Very Good | Excellent |

### Our Recommendations

**For Specification Writing & PRD Drafting:**
→ **Gemini CLI** (Gemini 2.5 Pro)
- Excellent at understanding complex requirements
- Great for documentation and planning
- Generous free tier
- Strong reasoning capabilities
- Excellent at generating shell scripts and automation

**For Coding (Budget Option):**
→ **Qwen Code 3**
- Completely free, runs locally
- Surprisingly good code quality
- Fast inference on modern hardware
- No API costs
- Good at bash commands and git workflows

**For Professional Coding:**
→ **Claude Code** (Sonnet 4.5)
- Best code quality and reasoning
- Excellent at understanding context
- Superior debugging capabilities
- Worth $20/month for professionals
- Best at complex shell automation and system tasks


### Index

- Gemini CLI: ./01_big_free_tiers/01_gemini_cli/
- Qwen Code CLI: ./01_big_free_tiers/02_qwen_code/
- Claude Code: ./02_paid_professional/01_claude_code/
- Learn Cursor: ./02_paid_professional/02_learn_cursor/
- ChatGPT‑5 Codex: ./02_paid_professional/03_codex/
