# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic.v1 import validate_arguments, ValidationError
from typing import overload, Optional, Union, Awaitable

from typing_extensions import Annotated
from datetime import datetime

from pydantic.v1 import Field, StrictBool, StrictInt, StrictStr, conint, conlist, constr, validator

from typing import Optional

from lusid.models.create_data_type_request import CreateDataTypeRequest
from lusid.models.data_type import DataType
from lusid.models.deleted_entity_response import DeletedEntityResponse
from lusid.models.field_value import FieldValue
from lusid.models.paged_resource_list_of_data_type_summary import PagedResourceListOfDataTypeSummary
from lusid.models.resource_list_of_data_type import ResourceListOfDataType
from lusid.models.resource_list_of_i_unit_definition_dto import ResourceListOfIUnitDefinitionDto
from lusid.models.update_data_type_request import UpdateDataTypeRequest
from lusid.models.update_reference_data_request import UpdateReferenceDataRequest

from lusid.api_client import ApiClient
from lusid.api_response import ApiResponse
from lusid.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)
from lusid.extensions.configuration_options import ConfigurationOptions


class DataTypesApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @overload
    async def create_data_type(self, create_data_type_request : Annotated[Optional[CreateDataTypeRequest], Field(description="The definition of the new data type")] = None, **kwargs) -> DataType:  # noqa: E501
        ...

    @overload
    def create_data_type(self, create_data_type_request : Annotated[Optional[CreateDataTypeRequest], Field(description="The definition of the new data type")] = None, async_req: Optional[bool]=True, **kwargs) -> DataType:  # noqa: E501
        ...

    @validate_arguments
    def create_data_type(self, create_data_type_request : Annotated[Optional[CreateDataTypeRequest], Field(description="The definition of the new data type")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[DataType, Awaitable[DataType]]:  # noqa: E501
        """[EARLY ACCESS] CreateDataType: Create data type definition  # noqa: E501

        Create a new data type definition    Data types cannot be created in either the \"default\" or \"system\" scopes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_data_type(create_data_type_request, async_req=True)
        >>> result = thread.get()

        :param create_data_type_request: The definition of the new data type
        :type create_data_type_request: CreateDataTypeRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DataType
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the create_data_type_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.create_data_type_with_http_info(create_data_type_request, **kwargs)  # noqa: E501

    @validate_arguments
    def create_data_type_with_http_info(self, create_data_type_request : Annotated[Optional[CreateDataTypeRequest], Field(description="The definition of the new data type")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] CreateDataType: Create data type definition  # noqa: E501

        Create a new data type definition    Data types cannot be created in either the \"default\" or \"system\" scopes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_data_type_with_http_info(create_data_type_request, async_req=True)
        >>> result = thread.get()

        :param create_data_type_request: The definition of the new data type
        :type create_data_type_request: CreateDataTypeRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DataType, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'create_data_type_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_data_type" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['create_data_type_request'] is not None:
            _body_params = _params['create_data_type_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '201': "DataType",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/datatypes', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    async def delete_data_type(self, scope : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The scope of the data type")], code : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The code of the data type")], **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @overload
    def delete_data_type(self, scope : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The scope of the data type")], code : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The code of the data type")], async_req: Optional[bool]=True, **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @validate_arguments
    def delete_data_type(self, scope : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The scope of the data type")], code : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The code of the data type")], async_req: Optional[bool]=None, **kwargs) -> Union[DeletedEntityResponse, Awaitable[DeletedEntityResponse]]:  # noqa: E501
        """DeleteDataType: Delete a data type definition.  # noqa: E501

        Delete an existing data type definition.    Data types cannot be deleted in either the \"default\" or \"system\" scopes, scopes beginning with \"LUSID-\",  or data types that are in use on a property definition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_data_type(scope, code, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the data type (required)
        :type scope: str
        :param code: The code of the data type (required)
        :type code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DeletedEntityResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_data_type_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.delete_data_type_with_http_info(scope, code, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_data_type_with_http_info(self, scope : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The scope of the data type")], code : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The code of the data type")], **kwargs) -> ApiResponse:  # noqa: E501
        """DeleteDataType: Delete a data type definition.  # noqa: E501

        Delete an existing data type definition.    Data types cannot be deleted in either the \"default\" or \"system\" scopes, scopes beginning with \"LUSID-\",  or data types that are in use on a property definition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_data_type_with_http_info(scope, code, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the data type (required)
        :type scope: str
        :param code: The code of the data type (required)
        :type code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DeletedEntityResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_data_type" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "DeletedEntityResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/datatypes/{scope}/{code}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    async def get_data_type(self, scope : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The scope of the data type")], code : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The code of the data type")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the data type definition. Defaults to              return the latest version of the instrument definition if not specified.")] = None, **kwargs) -> DataType:  # noqa: E501
        ...

    @overload
    def get_data_type(self, scope : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The scope of the data type")], code : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The code of the data type")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the data type definition. Defaults to              return the latest version of the instrument definition if not specified.")] = None, async_req: Optional[bool]=True, **kwargs) -> DataType:  # noqa: E501
        ...

    @validate_arguments
    def get_data_type(self, scope : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The scope of the data type")], code : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The code of the data type")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the data type definition. Defaults to              return the latest version of the instrument definition if not specified.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[DataType, Awaitable[DataType]]:  # noqa: E501
        """GetDataType: Get data type definition  # noqa: E501

        Get the definition of a specified data type  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_data_type(scope, code, as_at, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the data type (required)
        :type scope: str
        :param code: The code of the data type (required)
        :type code: str
        :param as_at: The asAt datetime at which to retrieve the data type definition. Defaults to              return the latest version of the instrument definition if not specified.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DataType
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_data_type_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_data_type_with_http_info(scope, code, as_at, **kwargs)  # noqa: E501

    @validate_arguments
    def get_data_type_with_http_info(self, scope : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The scope of the data type")], code : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The code of the data type")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the data type definition. Defaults to              return the latest version of the instrument definition if not specified.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """GetDataType: Get data type definition  # noqa: E501

        Get the definition of a specified data type  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_data_type_with_http_info(scope, code, as_at, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the data type (required)
        :type scope: str
        :param code: The code of the data type (required)
        :type code: str
        :param as_at: The asAt datetime at which to retrieve the data type definition. Defaults to              return the latest version of the instrument definition if not specified.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DataType, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'as_at'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_data_type" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "DataType",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/datatypes/{scope}/{code}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    async def get_units_from_data_type(self, scope : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The scope of the data type")], code : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The code of the data type")], units : Annotated[Optional[conlist(StrictStr)], Field(description="One or more unit identifiers for which the definition is being requested")] = None, filter : Annotated[Optional[constr(strict=True, max_length=16384, min_length=0)], Field(description="Optional. Expression to filter the result set.               For example, to filter on the Schema, use \"schema eq 'string'\"              Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, as_at : Annotated[Optional[datetime], Field(description="Optional. The as at of the requested data type")] = None, **kwargs) -> ResourceListOfIUnitDefinitionDto:  # noqa: E501
        ...

    @overload
    def get_units_from_data_type(self, scope : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The scope of the data type")], code : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The code of the data type")], units : Annotated[Optional[conlist(StrictStr)], Field(description="One or more unit identifiers for which the definition is being requested")] = None, filter : Annotated[Optional[constr(strict=True, max_length=16384, min_length=0)], Field(description="Optional. Expression to filter the result set.               For example, to filter on the Schema, use \"schema eq 'string'\"              Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, as_at : Annotated[Optional[datetime], Field(description="Optional. The as at of the requested data type")] = None, async_req: Optional[bool]=True, **kwargs) -> ResourceListOfIUnitDefinitionDto:  # noqa: E501
        ...

    @validate_arguments
    def get_units_from_data_type(self, scope : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The scope of the data type")], code : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The code of the data type")], units : Annotated[Optional[conlist(StrictStr)], Field(description="One or more unit identifiers for which the definition is being requested")] = None, filter : Annotated[Optional[constr(strict=True, max_length=16384, min_length=0)], Field(description="Optional. Expression to filter the result set.               For example, to filter on the Schema, use \"schema eq 'string'\"              Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, as_at : Annotated[Optional[datetime], Field(description="Optional. The as at of the requested data type")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[ResourceListOfIUnitDefinitionDto, Awaitable[ResourceListOfIUnitDefinitionDto]]:  # noqa: E501
        """[EARLY ACCESS] GetUnitsFromDataType: Get units from data type  # noqa: E501

        Get the definitions of the specified units associated bound to a specific data type  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_units_from_data_type(scope, code, units, filter, as_at, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the data type (required)
        :type scope: str
        :param code: The code of the data type (required)
        :type code: str
        :param units: One or more unit identifiers for which the definition is being requested
        :type units: List[str]
        :param filter: Optional. Expression to filter the result set.               For example, to filter on the Schema, use \"schema eq 'string'\"              Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param as_at: Optional. The as at of the requested data type
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResourceListOfIUnitDefinitionDto
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_units_from_data_type_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_units_from_data_type_with_http_info(scope, code, units, filter, as_at, **kwargs)  # noqa: E501

    @validate_arguments
    def get_units_from_data_type_with_http_info(self, scope : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The scope of the data type")], code : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The code of the data type")], units : Annotated[Optional[conlist(StrictStr)], Field(description="One or more unit identifiers for which the definition is being requested")] = None, filter : Annotated[Optional[constr(strict=True, max_length=16384, min_length=0)], Field(description="Optional. Expression to filter the result set.               For example, to filter on the Schema, use \"schema eq 'string'\"              Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, as_at : Annotated[Optional[datetime], Field(description="Optional. The as at of the requested data type")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] GetUnitsFromDataType: Get units from data type  # noqa: E501

        Get the definitions of the specified units associated bound to a specific data type  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_units_from_data_type_with_http_info(scope, code, units, filter, as_at, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the data type (required)
        :type scope: str
        :param code: The code of the data type (required)
        :type code: str
        :param units: One or more unit identifiers for which the definition is being requested
        :type units: List[str]
        :param filter: Optional. Expression to filter the result set.               For example, to filter on the Schema, use \"schema eq 'string'\"              Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param as_at: Optional. The as at of the requested data type
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResourceListOfIUnitDefinitionDto, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'units',
            'filter',
            'as_at'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_units_from_data_type" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('units') is not None:  # noqa: E501
            _query_params.append(('units', _params['units']))
            _collection_formats['units'] = 'multi'

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ResourceListOfIUnitDefinitionDto",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/datatypes/{scope}/{code}/units', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    async def list_data_type_summaries(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the data type summaries. Defaults to returning the latest version               of each summary if not specified.")] = None, page : Annotated[Optional[constr(strict=True, max_length=500, min_length=1)], Field(description="The pagination token to use to continue listing data type summaries. This  value is returned from the previous call. If a pagination token is provided, the filter, sortBy  and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True, le=5000, ge=1)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[constr(strict=True, max_length=16384, min_length=0)], Field(description="Optional. Expression to filter the result set.                For example, to filter on the Scope, use \"id.scope eq 'myscope'\", to filter on Schema, use \"schema eq 'string'\",               to filter on AcceptableValues use \"acceptableValues any (~ eq 'value')\"               Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names to sort by, each suffixed by \" ASC\" or \" DESC\"")] = None, **kwargs) -> PagedResourceListOfDataTypeSummary:  # noqa: E501
        ...

    @overload
    def list_data_type_summaries(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the data type summaries. Defaults to returning the latest version               of each summary if not specified.")] = None, page : Annotated[Optional[constr(strict=True, max_length=500, min_length=1)], Field(description="The pagination token to use to continue listing data type summaries. This  value is returned from the previous call. If a pagination token is provided, the filter, sortBy  and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True, le=5000, ge=1)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[constr(strict=True, max_length=16384, min_length=0)], Field(description="Optional. Expression to filter the result set.                For example, to filter on the Scope, use \"id.scope eq 'myscope'\", to filter on Schema, use \"schema eq 'string'\",               to filter on AcceptableValues use \"acceptableValues any (~ eq 'value')\"               Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names to sort by, each suffixed by \" ASC\" or \" DESC\"")] = None, async_req: Optional[bool]=True, **kwargs) -> PagedResourceListOfDataTypeSummary:  # noqa: E501
        ...

    @validate_arguments
    def list_data_type_summaries(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the data type summaries. Defaults to returning the latest version               of each summary if not specified.")] = None, page : Annotated[Optional[constr(strict=True, max_length=500, min_length=1)], Field(description="The pagination token to use to continue listing data type summaries. This  value is returned from the previous call. If a pagination token is provided, the filter, sortBy  and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True, le=5000, ge=1)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[constr(strict=True, max_length=16384, min_length=0)], Field(description="Optional. Expression to filter the result set.                For example, to filter on the Scope, use \"id.scope eq 'myscope'\", to filter on Schema, use \"schema eq 'string'\",               to filter on AcceptableValues use \"acceptableValues any (~ eq 'value')\"               Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names to sort by, each suffixed by \" ASC\" or \" DESC\"")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[PagedResourceListOfDataTypeSummary, Awaitable[PagedResourceListOfDataTypeSummary]]:  # noqa: E501
        """[EARLY ACCESS] ListDataTypeSummaries: List all data type summaries, without the reference data  # noqa: E501

        List all data type summaries  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_data_type_summaries(as_at, page, limit, filter, sort_by, async_req=True)
        >>> result = thread.get()

        :param as_at: The asAt datetime at which to list the data type summaries. Defaults to returning the latest version               of each summary if not specified.
        :type as_at: datetime
        :param page: The pagination token to use to continue listing data type summaries. This  value is returned from the previous call. If a pagination token is provided, the filter, sortBy  and asAt fields must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the results to this number. Defaults to 100 if not specified.
        :type limit: int
        :param filter: Optional. Expression to filter the result set.                For example, to filter on the Scope, use \"id.scope eq 'myscope'\", to filter on Schema, use \"schema eq 'string'\",               to filter on AcceptableValues use \"acceptableValues any (~ eq 'value')\"               Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param sort_by: A list of field names to sort by, each suffixed by \" ASC\" or \" DESC\"
        :type sort_by: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PagedResourceListOfDataTypeSummary
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_data_type_summaries_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.list_data_type_summaries_with_http_info(as_at, page, limit, filter, sort_by, **kwargs)  # noqa: E501

    @validate_arguments
    def list_data_type_summaries_with_http_info(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the data type summaries. Defaults to returning the latest version               of each summary if not specified.")] = None, page : Annotated[Optional[constr(strict=True, max_length=500, min_length=1)], Field(description="The pagination token to use to continue listing data type summaries. This  value is returned from the previous call. If a pagination token is provided, the filter, sortBy  and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True, le=5000, ge=1)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[constr(strict=True, max_length=16384, min_length=0)], Field(description="Optional. Expression to filter the result set.                For example, to filter on the Scope, use \"id.scope eq 'myscope'\", to filter on Schema, use \"schema eq 'string'\",               to filter on AcceptableValues use \"acceptableValues any (~ eq 'value')\"               Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names to sort by, each suffixed by \" ASC\" or \" DESC\"")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] ListDataTypeSummaries: List all data type summaries, without the reference data  # noqa: E501

        List all data type summaries  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_data_type_summaries_with_http_info(as_at, page, limit, filter, sort_by, async_req=True)
        >>> result = thread.get()

        :param as_at: The asAt datetime at which to list the data type summaries. Defaults to returning the latest version               of each summary if not specified.
        :type as_at: datetime
        :param page: The pagination token to use to continue listing data type summaries. This  value is returned from the previous call. If a pagination token is provided, the filter, sortBy  and asAt fields must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the results to this number. Defaults to 100 if not specified.
        :type limit: int
        :param filter: Optional. Expression to filter the result set.                For example, to filter on the Scope, use \"id.scope eq 'myscope'\", to filter on Schema, use \"schema eq 'string'\",               to filter on AcceptableValues use \"acceptableValues any (~ eq 'value')\"               Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param sort_by: A list of field names to sort by, each suffixed by \" ASC\" or \" DESC\"
        :type sort_by: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PagedResourceListOfDataTypeSummary, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'as_at',
            'page',
            'limit',
            'filter',
            'sort_by'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_data_type_summaries" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        if _params.get('sort_by') is not None:  # noqa: E501
            _query_params.append(('sortBy', _params['sort_by']))
            _collection_formats['sortBy'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "PagedResourceListOfDataTypeSummary",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/datatypes', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    async def list_data_types(self, scope : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The requested scope of the data types")], as_at : Annotated[Optional[datetime], Field(description="The as at of the requested data types")] = None, include_system : Annotated[Optional[StrictBool], Field(description="Whether to additionally include those data types in the \"system\" scope")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="Optional. Order the results by these fields. Use use the '-' sign to denote descending order e.g. -MyFieldName")] = None, limit : Annotated[Optional[StrictInt], Field(description="Optional. When paginating, limit the number of returned results to this many.")] = None, filter : Annotated[Optional[constr(strict=True, max_length=16384, min_length=0)], Field(description="Optional. Expression to filter the result set.              For example, to filter on the Display Name, use \"displayName eq 'string'\"              Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, **kwargs) -> ResourceListOfDataType:  # noqa: E501
        ...

    @overload
    def list_data_types(self, scope : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The requested scope of the data types")], as_at : Annotated[Optional[datetime], Field(description="The as at of the requested data types")] = None, include_system : Annotated[Optional[StrictBool], Field(description="Whether to additionally include those data types in the \"system\" scope")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="Optional. Order the results by these fields. Use use the '-' sign to denote descending order e.g. -MyFieldName")] = None, limit : Annotated[Optional[StrictInt], Field(description="Optional. When paginating, limit the number of returned results to this many.")] = None, filter : Annotated[Optional[constr(strict=True, max_length=16384, min_length=0)], Field(description="Optional. Expression to filter the result set.              For example, to filter on the Display Name, use \"displayName eq 'string'\"              Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, async_req: Optional[bool]=True, **kwargs) -> ResourceListOfDataType:  # noqa: E501
        ...

    @validate_arguments
    def list_data_types(self, scope : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The requested scope of the data types")], as_at : Annotated[Optional[datetime], Field(description="The as at of the requested data types")] = None, include_system : Annotated[Optional[StrictBool], Field(description="Whether to additionally include those data types in the \"system\" scope")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="Optional. Order the results by these fields. Use use the '-' sign to denote descending order e.g. -MyFieldName")] = None, limit : Annotated[Optional[StrictInt], Field(description="Optional. When paginating, limit the number of returned results to this many.")] = None, filter : Annotated[Optional[constr(strict=True, max_length=16384, min_length=0)], Field(description="Optional. Expression to filter the result set.              For example, to filter on the Display Name, use \"displayName eq 'string'\"              Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[ResourceListOfDataType, Awaitable[ResourceListOfDataType]]:  # noqa: E501
        """ListDataTypes: List data types  # noqa: E501

        List all data types in a specified scope  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_data_types(scope, as_at, include_system, sort_by, limit, filter, async_req=True)
        >>> result = thread.get()

        :param scope: The requested scope of the data types (required)
        :type scope: str
        :param as_at: The as at of the requested data types
        :type as_at: datetime
        :param include_system: Whether to additionally include those data types in the \"system\" scope
        :type include_system: bool
        :param sort_by: Optional. Order the results by these fields. Use use the '-' sign to denote descending order e.g. -MyFieldName
        :type sort_by: List[str]
        :param limit: Optional. When paginating, limit the number of returned results to this many.
        :type limit: int
        :param filter: Optional. Expression to filter the result set.              For example, to filter on the Display Name, use \"displayName eq 'string'\"              Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResourceListOfDataType
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_data_types_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.list_data_types_with_http_info(scope, as_at, include_system, sort_by, limit, filter, **kwargs)  # noqa: E501

    @validate_arguments
    def list_data_types_with_http_info(self, scope : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The requested scope of the data types")], as_at : Annotated[Optional[datetime], Field(description="The as at of the requested data types")] = None, include_system : Annotated[Optional[StrictBool], Field(description="Whether to additionally include those data types in the \"system\" scope")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="Optional. Order the results by these fields. Use use the '-' sign to denote descending order e.g. -MyFieldName")] = None, limit : Annotated[Optional[StrictInt], Field(description="Optional. When paginating, limit the number of returned results to this many.")] = None, filter : Annotated[Optional[constr(strict=True, max_length=16384, min_length=0)], Field(description="Optional. Expression to filter the result set.              For example, to filter on the Display Name, use \"displayName eq 'string'\"              Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """ListDataTypes: List data types  # noqa: E501

        List all data types in a specified scope  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_data_types_with_http_info(scope, as_at, include_system, sort_by, limit, filter, async_req=True)
        >>> result = thread.get()

        :param scope: The requested scope of the data types (required)
        :type scope: str
        :param as_at: The as at of the requested data types
        :type as_at: datetime
        :param include_system: Whether to additionally include those data types in the \"system\" scope
        :type include_system: bool
        :param sort_by: Optional. Order the results by these fields. Use use the '-' sign to denote descending order e.g. -MyFieldName
        :type sort_by: List[str]
        :param limit: Optional. When paginating, limit the number of returned results to this many.
        :type limit: int
        :param filter: Optional. Expression to filter the result set.              For example, to filter on the Display Name, use \"displayName eq 'string'\"              Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResourceListOfDataType, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'as_at',
            'include_system',
            'sort_by',
            'limit',
            'filter'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_data_types" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']


        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('include_system') is not None:  # noqa: E501
            _query_params.append(('includeSystem', _params['include_system']))

        if _params.get('sort_by') is not None:  # noqa: E501
            _query_params.append(('sortBy', _params['sort_by']))
            _collection_formats['sortBy'] = 'multi'

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ResourceListOfDataType",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/datatypes/{scope}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    async def update_data_type(self, scope : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The scope of the data type")], code : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The code of the data type")], update_data_type_request : Annotated[UpdateDataTypeRequest, Field(..., description="The updated definition of the data type")], **kwargs) -> DataType:  # noqa: E501
        ...

    @overload
    def update_data_type(self, scope : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The scope of the data type")], code : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The code of the data type")], update_data_type_request : Annotated[UpdateDataTypeRequest, Field(..., description="The updated definition of the data type")], async_req: Optional[bool]=True, **kwargs) -> DataType:  # noqa: E501
        ...

    @validate_arguments
    def update_data_type(self, scope : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The scope of the data type")], code : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The code of the data type")], update_data_type_request : Annotated[UpdateDataTypeRequest, Field(..., description="The updated definition of the data type")], async_req: Optional[bool]=None, **kwargs) -> Union[DataType, Awaitable[DataType]]:  # noqa: E501
        """[EARLY ACCESS] UpdateDataType: Update data type definition  # noqa: E501

        Update the definition of the specified existing data type    Not all elements within a data type definition are modifiable due to the potential implications for data  already stored against the types  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_data_type(scope, code, update_data_type_request, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the data type (required)
        :type scope: str
        :param code: The code of the data type (required)
        :type code: str
        :param update_data_type_request: The updated definition of the data type (required)
        :type update_data_type_request: UpdateDataTypeRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DataType
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the update_data_type_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.update_data_type_with_http_info(scope, code, update_data_type_request, **kwargs)  # noqa: E501

    @validate_arguments
    def update_data_type_with_http_info(self, scope : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The scope of the data type")], code : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The code of the data type")], update_data_type_request : Annotated[UpdateDataTypeRequest, Field(..., description="The updated definition of the data type")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] UpdateDataType: Update data type definition  # noqa: E501

        Update the definition of the specified existing data type    Not all elements within a data type definition are modifiable due to the potential implications for data  already stored against the types  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_data_type_with_http_info(scope, code, update_data_type_request, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the data type (required)
        :type scope: str
        :param code: The code of the data type (required)
        :type code: str
        :param update_data_type_request: The updated definition of the data type (required)
        :type update_data_type_request: UpdateDataTypeRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DataType, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'update_data_type_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_data_type" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['update_data_type_request'] is not None:
            _body_params = _params['update_data_type_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "DataType",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/datatypes/{scope}/{code}', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    async def update_reference_data(self, scope : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The scope of the data type")], code : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The code of the data type")], update_reference_data_request : Annotated[UpdateReferenceDataRequest, Field(..., description="The updated reference data")], **kwargs) -> DataType:  # noqa: E501
        ...

    @overload
    def update_reference_data(self, scope : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The scope of the data type")], code : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The code of the data type")], update_reference_data_request : Annotated[UpdateReferenceDataRequest, Field(..., description="The updated reference data")], async_req: Optional[bool]=True, **kwargs) -> DataType:  # noqa: E501
        ...

    @validate_arguments
    def update_reference_data(self, scope : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The scope of the data type")], code : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The code of the data type")], update_reference_data_request : Annotated[UpdateReferenceDataRequest, Field(..., description="The updated reference data")], async_req: Optional[bool]=None, **kwargs) -> Union[DataType, Awaitable[DataType]]:  # noqa: E501
        """[EARLY ACCESS] UpdateReferenceData: Update all reference data on a data type, includes the reference values, the field definitions, field values  # noqa: E501

        Replaces the whole set of reference data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_reference_data(scope, code, update_reference_data_request, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the data type (required)
        :type scope: str
        :param code: The code of the data type (required)
        :type code: str
        :param update_reference_data_request: The updated reference data (required)
        :type update_reference_data_request: UpdateReferenceDataRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DataType
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the update_reference_data_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.update_reference_data_with_http_info(scope, code, update_reference_data_request, **kwargs)  # noqa: E501

    @validate_arguments
    def update_reference_data_with_http_info(self, scope : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The scope of the data type")], code : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The code of the data type")], update_reference_data_request : Annotated[UpdateReferenceDataRequest, Field(..., description="The updated reference data")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] UpdateReferenceData: Update all reference data on a data type, includes the reference values, the field definitions, field values  # noqa: E501

        Replaces the whole set of reference data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_reference_data_with_http_info(scope, code, update_reference_data_request, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the data type (required)
        :type scope: str
        :param code: The code of the data type (required)
        :type code: str
        :param update_reference_data_request: The updated reference data (required)
        :type update_reference_data_request: UpdateReferenceDataRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DataType, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'update_reference_data_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_reference_data" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['update_reference_data_request'] is not None:
            _body_params = _params['update_reference_data_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "DataType",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/datatypes/{scope}/{code}/referencedata', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    async def update_reference_values(self, scope : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The scope of the data type")], code : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The code of the data type")], field_value : Annotated[conlist(FieldValue), Field(..., description="The updated reference values")], **kwargs) -> DataType:  # noqa: E501
        ...

    @overload
    def update_reference_values(self, scope : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The scope of the data type")], code : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The code of the data type")], field_value : Annotated[conlist(FieldValue), Field(..., description="The updated reference values")], async_req: Optional[bool]=True, **kwargs) -> DataType:  # noqa: E501
        ...

    @validate_arguments
    def update_reference_values(self, scope : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The scope of the data type")], code : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The code of the data type")], field_value : Annotated[conlist(FieldValue), Field(..., description="The updated reference values")], async_req: Optional[bool]=None, **kwargs) -> Union[DataType, Awaitable[DataType]]:  # noqa: E501
        """[EARLY ACCESS] UpdateReferenceValues: Update reference data on a data type  # noqa: E501

        Replaces the whole set of reference values  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_reference_values(scope, code, field_value, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the data type (required)
        :type scope: str
        :param code: The code of the data type (required)
        :type code: str
        :param field_value: The updated reference values (required)
        :type field_value: List[FieldValue]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DataType
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the update_reference_values_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.update_reference_values_with_http_info(scope, code, field_value, **kwargs)  # noqa: E501

    @validate_arguments
    def update_reference_values_with_http_info(self, scope : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The scope of the data type")], code : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The code of the data type")], field_value : Annotated[conlist(FieldValue), Field(..., description="The updated reference values")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] UpdateReferenceValues: Update reference data on a data type  # noqa: E501

        Replaces the whole set of reference values  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_reference_values_with_http_info(scope, code, field_value, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the data type (required)
        :type scope: str
        :param code: The code of the data type (required)
        :type code: str
        :param field_value: The updated reference values (required)
        :type field_value: List[FieldValue]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DataType, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'field_value'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_reference_values" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['field_value'] is not None:
            _body_params = _params['field_value']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "DataType",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/datatypes/{scope}/{code}/referencedatavalues', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
