# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic.v1 import validate_arguments, ValidationError
from typing import overload, Optional, Union, Awaitable

from typing_extensions import Annotated
from datetime import datetime

from pydantic.v1 import Field, StrictStr, conint, conlist, constr, validator

from typing import Optional

from lusid.models.paged_resource_list_of_transaction_template import PagedResourceListOfTransactionTemplate
from lusid.models.paged_resource_list_of_transaction_template_specification import PagedResourceListOfTransactionTemplateSpecification
from lusid.models.transaction_template import TransactionTemplate
from lusid.models.transaction_template_request import TransactionTemplateRequest
from lusid.models.transaction_template_specification import TransactionTemplateSpecification

from lusid.api_client import ApiClient
from lusid.api_response import ApiResponse
from lusid.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)
from lusid.extensions.configuration_options import ConfigurationOptions


class InstrumentEventTypesApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @overload
    async def create_transaction_template(self, instrument_event_type : Annotated[StrictStr, Field(..., description="The type of instrument events that the template is applied to.")], instrument_type : Annotated[StrictStr, Field(..., description="The instrument type of the transaction template. The combination of the instrument              event type, instrument type and scope uniquely identifies a transaction template")], scope : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The scope in which the template lies.")], transaction_template_request : Annotated[TransactionTemplateRequest, Field(..., description="A request defining a new transaction template to be created.")], **kwargs) -> TransactionTemplate:  # noqa: E501
        ...

    @overload
    def create_transaction_template(self, instrument_event_type : Annotated[StrictStr, Field(..., description="The type of instrument events that the template is applied to.")], instrument_type : Annotated[StrictStr, Field(..., description="The instrument type of the transaction template. The combination of the instrument              event type, instrument type and scope uniquely identifies a transaction template")], scope : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The scope in which the template lies.")], transaction_template_request : Annotated[TransactionTemplateRequest, Field(..., description="A request defining a new transaction template to be created.")], async_req: Optional[bool]=True, **kwargs) -> TransactionTemplate:  # noqa: E501
        ...

    @validate_arguments
    def create_transaction_template(self, instrument_event_type : Annotated[StrictStr, Field(..., description="The type of instrument events that the template is applied to.")], instrument_type : Annotated[StrictStr, Field(..., description="The instrument type of the transaction template. The combination of the instrument              event type, instrument type and scope uniquely identifies a transaction template")], scope : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The scope in which the template lies.")], transaction_template_request : Annotated[TransactionTemplateRequest, Field(..., description="A request defining a new transaction template to be created.")], async_req: Optional[bool]=None, **kwargs) -> Union[TransactionTemplate, Awaitable[TransactionTemplate]]:  # noqa: E501
        """[EXPERIMENTAL] CreateTransactionTemplate: Create Transaction Template  # noqa: E501

        Create a transaction template for a particular instrument event type in a scope.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_transaction_template(instrument_event_type, instrument_type, scope, transaction_template_request, async_req=True)
        >>> result = thread.get()

        :param instrument_event_type: The type of instrument events that the template is applied to. (required)
        :type instrument_event_type: str
        :param instrument_type: The instrument type of the transaction template. The combination of the instrument              event type, instrument type and scope uniquely identifies a transaction template (required)
        :type instrument_type: str
        :param scope: The scope in which the template lies. (required)
        :type scope: str
        :param transaction_template_request: A request defining a new transaction template to be created. (required)
        :type transaction_template_request: TransactionTemplateRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TransactionTemplate
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the create_transaction_template_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.create_transaction_template_with_http_info(instrument_event_type, instrument_type, scope, transaction_template_request, **kwargs)  # noqa: E501

    @validate_arguments
    def create_transaction_template_with_http_info(self, instrument_event_type : Annotated[StrictStr, Field(..., description="The type of instrument events that the template is applied to.")], instrument_type : Annotated[StrictStr, Field(..., description="The instrument type of the transaction template. The combination of the instrument              event type, instrument type and scope uniquely identifies a transaction template")], scope : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The scope in which the template lies.")], transaction_template_request : Annotated[TransactionTemplateRequest, Field(..., description="A request defining a new transaction template to be created.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] CreateTransactionTemplate: Create Transaction Template  # noqa: E501

        Create a transaction template for a particular instrument event type in a scope.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_transaction_template_with_http_info(instrument_event_type, instrument_type, scope, transaction_template_request, async_req=True)
        >>> result = thread.get()

        :param instrument_event_type: The type of instrument events that the template is applied to. (required)
        :type instrument_event_type: str
        :param instrument_type: The instrument type of the transaction template. The combination of the instrument              event type, instrument type and scope uniquely identifies a transaction template (required)
        :type instrument_type: str
        :param scope: The scope in which the template lies. (required)
        :type scope: str
        :param transaction_template_request: A request defining a new transaction template to be created. (required)
        :type transaction_template_request: TransactionTemplateRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(TransactionTemplate, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'instrument_event_type',
            'instrument_type',
            'scope',
            'transaction_template_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_transaction_template" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['instrument_event_type']:
            _path_params['instrumentEventType'] = _params['instrument_event_type']

        if _params['instrument_type']:
            _path_params['instrumentType'] = _params['instrument_type']

        if _params['scope']:
            _path_params['scope'] = _params['scope']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['transaction_template_request'] is not None:
            _body_params = _params['transaction_template_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '201': "TransactionTemplate",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/instrumenteventtypes/{instrumentEventType}/transactiontemplates/{instrumentType}/{scope}', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    async def delete_transaction_template(self, instrument_event_type : Annotated[StrictStr, Field(..., description="The type of instrument events that the template is applied to.")], instrument_type : Annotated[StrictStr, Field(..., description="The instrument type of the transaction template. The combination of the instrument              event type, instrument type and scope uniquely identifies a transaction template")], scope : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The scope of the template.")], **kwargs) -> datetime:  # noqa: E501
        ...

    @overload
    def delete_transaction_template(self, instrument_event_type : Annotated[StrictStr, Field(..., description="The type of instrument events that the template is applied to.")], instrument_type : Annotated[StrictStr, Field(..., description="The instrument type of the transaction template. The combination of the instrument              event type, instrument type and scope uniquely identifies a transaction template")], scope : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The scope of the template.")], async_req: Optional[bool]=True, **kwargs) -> datetime:  # noqa: E501
        ...

    @validate_arguments
    def delete_transaction_template(self, instrument_event_type : Annotated[StrictStr, Field(..., description="The type of instrument events that the template is applied to.")], instrument_type : Annotated[StrictStr, Field(..., description="The instrument type of the transaction template. The combination of the instrument              event type, instrument type and scope uniquely identifies a transaction template")], scope : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The scope of the template.")], async_req: Optional[bool]=None, **kwargs) -> Union[datetime, Awaitable[datetime]]:  # noqa: E501
        """[EXPERIMENTAL] DeleteTransactionTemplate: Delete Transaction Template  # noqa: E501

        Delete a transaction template for a particular instrument event type in a scope.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_transaction_template(instrument_event_type, instrument_type, scope, async_req=True)
        >>> result = thread.get()

        :param instrument_event_type: The type of instrument events that the template is applied to. (required)
        :type instrument_event_type: str
        :param instrument_type: The instrument type of the transaction template. The combination of the instrument              event type, instrument type and scope uniquely identifies a transaction template (required)
        :type instrument_type: str
        :param scope: The scope of the template. (required)
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: datetime
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_transaction_template_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.delete_transaction_template_with_http_info(instrument_event_type, instrument_type, scope, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_transaction_template_with_http_info(self, instrument_event_type : Annotated[StrictStr, Field(..., description="The type of instrument events that the template is applied to.")], instrument_type : Annotated[StrictStr, Field(..., description="The instrument type of the transaction template. The combination of the instrument              event type, instrument type and scope uniquely identifies a transaction template")], scope : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The scope of the template.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] DeleteTransactionTemplate: Delete Transaction Template  # noqa: E501

        Delete a transaction template for a particular instrument event type in a scope.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_transaction_template_with_http_info(instrument_event_type, instrument_type, scope, async_req=True)
        >>> result = thread.get()

        :param instrument_event_type: The type of instrument events that the template is applied to. (required)
        :type instrument_event_type: str
        :param instrument_type: The instrument type of the transaction template. The combination of the instrument              event type, instrument type and scope uniquely identifies a transaction template (required)
        :type instrument_type: str
        :param scope: The scope of the template. (required)
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(datetime, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'instrument_event_type',
            'instrument_type',
            'scope'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_transaction_template" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['instrument_event_type']:
            _path_params['instrumentEventType'] = _params['instrument_event_type']

        if _params['instrument_type']:
            _path_params['instrumentType'] = _params['instrument_type']

        if _params['scope']:
            _path_params['scope'] = _params['scope']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "datetime",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/instrumenteventtypes/{instrumentEventType}/transactiontemplates/{instrumentType}/{scope}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    async def get_transaction_template(self, instrument_event_type : Annotated[StrictStr, Field(..., description="The instrument event type of the transaction template")], instrument_type : Annotated[StrictStr, Field(..., description="The instrument type of the transaction template. The combination of the instrument              event type, instrument type and scope uniquely identifies a transaction template")], scope : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The scope in which the template lies. When not supplied the scope is 'default'.")], as_at : Annotated[Optional[datetime], Field(description="The AsAt time of the requested Transaction Template")] = None, **kwargs) -> TransactionTemplate:  # noqa: E501
        ...

    @overload
    def get_transaction_template(self, instrument_event_type : Annotated[StrictStr, Field(..., description="The instrument event type of the transaction template")], instrument_type : Annotated[StrictStr, Field(..., description="The instrument type of the transaction template. The combination of the instrument              event type, instrument type and scope uniquely identifies a transaction template")], scope : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The scope in which the template lies. When not supplied the scope is 'default'.")], as_at : Annotated[Optional[datetime], Field(description="The AsAt time of the requested Transaction Template")] = None, async_req: Optional[bool]=True, **kwargs) -> TransactionTemplate:  # noqa: E501
        ...

    @validate_arguments
    def get_transaction_template(self, instrument_event_type : Annotated[StrictStr, Field(..., description="The instrument event type of the transaction template")], instrument_type : Annotated[StrictStr, Field(..., description="The instrument type of the transaction template. The combination of the instrument              event type, instrument type and scope uniquely identifies a transaction template")], scope : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The scope in which the template lies. When not supplied the scope is 'default'.")], as_at : Annotated[Optional[datetime], Field(description="The AsAt time of the requested Transaction Template")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[TransactionTemplate, Awaitable[TransactionTemplate]]:  # noqa: E501
        """[EXPERIMENTAL] GetTransactionTemplate: Get Transaction Template  # noqa: E501

        Gets the Transaction Template that for the instrument event type within the scope specified.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_transaction_template(instrument_event_type, instrument_type, scope, as_at, async_req=True)
        >>> result = thread.get()

        :param instrument_event_type: The instrument event type of the transaction template (required)
        :type instrument_event_type: str
        :param instrument_type: The instrument type of the transaction template. The combination of the instrument              event type, instrument type and scope uniquely identifies a transaction template (required)
        :type instrument_type: str
        :param scope: The scope in which the template lies. When not supplied the scope is 'default'. (required)
        :type scope: str
        :param as_at: The AsAt time of the requested Transaction Template
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TransactionTemplate
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_transaction_template_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_transaction_template_with_http_info(instrument_event_type, instrument_type, scope, as_at, **kwargs)  # noqa: E501

    @validate_arguments
    def get_transaction_template_with_http_info(self, instrument_event_type : Annotated[StrictStr, Field(..., description="The instrument event type of the transaction template")], instrument_type : Annotated[StrictStr, Field(..., description="The instrument type of the transaction template. The combination of the instrument              event type, instrument type and scope uniquely identifies a transaction template")], scope : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The scope in which the template lies. When not supplied the scope is 'default'.")], as_at : Annotated[Optional[datetime], Field(description="The AsAt time of the requested Transaction Template")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] GetTransactionTemplate: Get Transaction Template  # noqa: E501

        Gets the Transaction Template that for the instrument event type within the scope specified.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_transaction_template_with_http_info(instrument_event_type, instrument_type, scope, as_at, async_req=True)
        >>> result = thread.get()

        :param instrument_event_type: The instrument event type of the transaction template (required)
        :type instrument_event_type: str
        :param instrument_type: The instrument type of the transaction template. The combination of the instrument              event type, instrument type and scope uniquely identifies a transaction template (required)
        :type instrument_type: str
        :param scope: The scope in which the template lies. When not supplied the scope is 'default'. (required)
        :type scope: str
        :param as_at: The AsAt time of the requested Transaction Template
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(TransactionTemplate, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'instrument_event_type',
            'instrument_type',
            'scope',
            'as_at'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_transaction_template" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['instrument_event_type']:
            _path_params['instrumentEventType'] = _params['instrument_event_type']

        if _params['instrument_type']:
            _path_params['instrumentType'] = _params['instrument_type']

        if _params['scope']:
            _path_params['scope'] = _params['scope']


        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "TransactionTemplate",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/instrumenteventtypes/{instrumentEventType}/transactiontemplates/{instrumentType}/{scope}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    async def get_transaction_template_specification(self, instrument_event_type : Annotated[StrictStr, Field(..., description="The requested instrument event type.")], **kwargs) -> TransactionTemplateSpecification:  # noqa: E501
        ...

    @overload
    def get_transaction_template_specification(self, instrument_event_type : Annotated[StrictStr, Field(..., description="The requested instrument event type.")], async_req: Optional[bool]=True, **kwargs) -> TransactionTemplateSpecification:  # noqa: E501
        ...

    @validate_arguments
    def get_transaction_template_specification(self, instrument_event_type : Annotated[StrictStr, Field(..., description="The requested instrument event type.")], async_req: Optional[bool]=None, **kwargs) -> Union[TransactionTemplateSpecification, Awaitable[TransactionTemplateSpecification]]:  # noqa: E501
        """[EXPERIMENTAL] GetTransactionTemplateSpecification: Get Transaction Template Specification.  # noqa: E501

        Retrieve the transaction template specification for a particular event type.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_transaction_template_specification(instrument_event_type, async_req=True)
        >>> result = thread.get()

        :param instrument_event_type: The requested instrument event type. (required)
        :type instrument_event_type: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TransactionTemplateSpecification
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_transaction_template_specification_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_transaction_template_specification_with_http_info(instrument_event_type, **kwargs)  # noqa: E501

    @validate_arguments
    def get_transaction_template_specification_with_http_info(self, instrument_event_type : Annotated[StrictStr, Field(..., description="The requested instrument event type.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] GetTransactionTemplateSpecification: Get Transaction Template Specification.  # noqa: E501

        Retrieve the transaction template specification for a particular event type.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_transaction_template_specification_with_http_info(instrument_event_type, async_req=True)
        >>> result = thread.get()

        :param instrument_event_type: The requested instrument event type. (required)
        :type instrument_event_type: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(TransactionTemplateSpecification, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'instrument_event_type'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_transaction_template_specification" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['instrument_event_type']:
            _path_params['instrumentEventType'] = _params['instrument_event_type']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "TransactionTemplateSpecification",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/instrumenteventtypes/{instrumentEventType}/transactiontemplatespecification', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    async def list_transaction_template_specifications(self, as_at : Annotated[Optional[datetime], Field(description="AsAt of the request")] = None, page : Annotated[Optional[constr(strict=True, max_length=500, min_length=1)], Field(description="The pagination token to use to continue listing Transaction Template Specifications from              a previous call to list Transaction Template Specifications.              This value is returned from the previous call. If a pagination token is provided the sortBy, filter, and asAt              fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True, le=5000, ge=1)], Field(description="When paginating, limit the number of returned results to this many.")] = None, filter : Annotated[Optional[constr(strict=True, max_length=16384, min_length=0)], Field(description="Expression to filter the result set. Read more about filtering results from LUSID here:              https://support.lusid.com/filtering-results-from-lusid.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names to sort by, each suffixed by \" ASC\" or \" DESC\".")] = None, **kwargs) -> PagedResourceListOfTransactionTemplateSpecification:  # noqa: E501
        ...

    @overload
    def list_transaction_template_specifications(self, as_at : Annotated[Optional[datetime], Field(description="AsAt of the request")] = None, page : Annotated[Optional[constr(strict=True, max_length=500, min_length=1)], Field(description="The pagination token to use to continue listing Transaction Template Specifications from              a previous call to list Transaction Template Specifications.              This value is returned from the previous call. If a pagination token is provided the sortBy, filter, and asAt              fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True, le=5000, ge=1)], Field(description="When paginating, limit the number of returned results to this many.")] = None, filter : Annotated[Optional[constr(strict=True, max_length=16384, min_length=0)], Field(description="Expression to filter the result set. Read more about filtering results from LUSID here:              https://support.lusid.com/filtering-results-from-lusid.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names to sort by, each suffixed by \" ASC\" or \" DESC\".")] = None, async_req: Optional[bool]=True, **kwargs) -> PagedResourceListOfTransactionTemplateSpecification:  # noqa: E501
        ...

    @validate_arguments
    def list_transaction_template_specifications(self, as_at : Annotated[Optional[datetime], Field(description="AsAt of the request")] = None, page : Annotated[Optional[constr(strict=True, max_length=500, min_length=1)], Field(description="The pagination token to use to continue listing Transaction Template Specifications from              a previous call to list Transaction Template Specifications.              This value is returned from the previous call. If a pagination token is provided the sortBy, filter, and asAt              fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True, le=5000, ge=1)], Field(description="When paginating, limit the number of returned results to this many.")] = None, filter : Annotated[Optional[constr(strict=True, max_length=16384, min_length=0)], Field(description="Expression to filter the result set. Read more about filtering results from LUSID here:              https://support.lusid.com/filtering-results-from-lusid.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names to sort by, each suffixed by \" ASC\" or \" DESC\".")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[PagedResourceListOfTransactionTemplateSpecification, Awaitable[PagedResourceListOfTransactionTemplateSpecification]]:  # noqa: E501
        """[EXPERIMENTAL] ListTransactionTemplateSpecifications: List Transaction Template Specifications.  # noqa: E501

        Retrieves all transaction template specifications.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_transaction_template_specifications(as_at, page, limit, filter, sort_by, async_req=True)
        >>> result = thread.get()

        :param as_at: AsAt of the request
        :type as_at: datetime
        :param page: The pagination token to use to continue listing Transaction Template Specifications from              a previous call to list Transaction Template Specifications.              This value is returned from the previous call. If a pagination token is provided the sortBy, filter, and asAt              fields must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the number of returned results to this many.
        :type limit: int
        :param filter: Expression to filter the result set. Read more about filtering results from LUSID here:              https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param sort_by: A list of field names to sort by, each suffixed by \" ASC\" or \" DESC\".
        :type sort_by: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PagedResourceListOfTransactionTemplateSpecification
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_transaction_template_specifications_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.list_transaction_template_specifications_with_http_info(as_at, page, limit, filter, sort_by, **kwargs)  # noqa: E501

    @validate_arguments
    def list_transaction_template_specifications_with_http_info(self, as_at : Annotated[Optional[datetime], Field(description="AsAt of the request")] = None, page : Annotated[Optional[constr(strict=True, max_length=500, min_length=1)], Field(description="The pagination token to use to continue listing Transaction Template Specifications from              a previous call to list Transaction Template Specifications.              This value is returned from the previous call. If a pagination token is provided the sortBy, filter, and asAt              fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True, le=5000, ge=1)], Field(description="When paginating, limit the number of returned results to this many.")] = None, filter : Annotated[Optional[constr(strict=True, max_length=16384, min_length=0)], Field(description="Expression to filter the result set. Read more about filtering results from LUSID here:              https://support.lusid.com/filtering-results-from-lusid.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names to sort by, each suffixed by \" ASC\" or \" DESC\".")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] ListTransactionTemplateSpecifications: List Transaction Template Specifications.  # noqa: E501

        Retrieves all transaction template specifications.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_transaction_template_specifications_with_http_info(as_at, page, limit, filter, sort_by, async_req=True)
        >>> result = thread.get()

        :param as_at: AsAt of the request
        :type as_at: datetime
        :param page: The pagination token to use to continue listing Transaction Template Specifications from              a previous call to list Transaction Template Specifications.              This value is returned from the previous call. If a pagination token is provided the sortBy, filter, and asAt              fields must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the number of returned results to this many.
        :type limit: int
        :param filter: Expression to filter the result set. Read more about filtering results from LUSID here:              https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param sort_by: A list of field names to sort by, each suffixed by \" ASC\" or \" DESC\".
        :type sort_by: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PagedResourceListOfTransactionTemplateSpecification, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'as_at',
            'page',
            'limit',
            'filter',
            'sort_by'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_transaction_template_specifications" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        if _params.get('sort_by') is not None:  # noqa: E501
            _query_params.append(('sortBy', _params['sort_by']))
            _collection_formats['sortBy'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "PagedResourceListOfTransactionTemplateSpecification",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/instrumenteventtypes/transactiontemplatespecifications', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    async def list_transaction_templates(self, as_at : Annotated[Optional[datetime], Field(description="The AsAt time at which to retrieve the Transaction Templates")] = None, page : Annotated[Optional[constr(strict=True, max_length=500, min_length=1)], Field(description="The pagination token to use to continue listing Transaction Templates from a previous call to list Transaction Templates.              This value is returned from the previous call. If a pagination token is provided the sortBy, filter, limit, and asAt fields              must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True, le=5000, ge=1)], Field(description="When paginating, limit the number of returned results to this many.")] = None, filter : Annotated[Optional[constr(strict=True, max_length=16384, min_length=0)], Field(description="Expression to filter the result set. Read more about filtering results from LUSID here:              https://support.lusid.com/filtering-results-from-lusid.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names to sort by, each suffixed by \" ASC\" or \" DESC\"")] = None, **kwargs) -> PagedResourceListOfTransactionTemplate:  # noqa: E501
        ...

    @overload
    def list_transaction_templates(self, as_at : Annotated[Optional[datetime], Field(description="The AsAt time at which to retrieve the Transaction Templates")] = None, page : Annotated[Optional[constr(strict=True, max_length=500, min_length=1)], Field(description="The pagination token to use to continue listing Transaction Templates from a previous call to list Transaction Templates.              This value is returned from the previous call. If a pagination token is provided the sortBy, filter, limit, and asAt fields              must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True, le=5000, ge=1)], Field(description="When paginating, limit the number of returned results to this many.")] = None, filter : Annotated[Optional[constr(strict=True, max_length=16384, min_length=0)], Field(description="Expression to filter the result set. Read more about filtering results from LUSID here:              https://support.lusid.com/filtering-results-from-lusid.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names to sort by, each suffixed by \" ASC\" or \" DESC\"")] = None, async_req: Optional[bool]=True, **kwargs) -> PagedResourceListOfTransactionTemplate:  # noqa: E501
        ...

    @validate_arguments
    def list_transaction_templates(self, as_at : Annotated[Optional[datetime], Field(description="The AsAt time at which to retrieve the Transaction Templates")] = None, page : Annotated[Optional[constr(strict=True, max_length=500, min_length=1)], Field(description="The pagination token to use to continue listing Transaction Templates from a previous call to list Transaction Templates.              This value is returned from the previous call. If a pagination token is provided the sortBy, filter, limit, and asAt fields              must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True, le=5000, ge=1)], Field(description="When paginating, limit the number of returned results to this many.")] = None, filter : Annotated[Optional[constr(strict=True, max_length=16384, min_length=0)], Field(description="Expression to filter the result set. Read more about filtering results from LUSID here:              https://support.lusid.com/filtering-results-from-lusid.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names to sort by, each suffixed by \" ASC\" or \" DESC\"")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[PagedResourceListOfTransactionTemplate, Awaitable[PagedResourceListOfTransactionTemplate]]:  # noqa: E501
        """[EXPERIMENTAL] ListTransactionTemplates: List Transaction Templates  # noqa: E501

        Lists all Transaction Templates.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_transaction_templates(as_at, page, limit, filter, sort_by, async_req=True)
        >>> result = thread.get()

        :param as_at: The AsAt time at which to retrieve the Transaction Templates
        :type as_at: datetime
        :param page: The pagination token to use to continue listing Transaction Templates from a previous call to list Transaction Templates.              This value is returned from the previous call. If a pagination token is provided the sortBy, filter, limit, and asAt fields              must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the number of returned results to this many.
        :type limit: int
        :param filter: Expression to filter the result set. Read more about filtering results from LUSID here:              https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param sort_by: A list of field names to sort by, each suffixed by \" ASC\" or \" DESC\"
        :type sort_by: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PagedResourceListOfTransactionTemplate
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_transaction_templates_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.list_transaction_templates_with_http_info(as_at, page, limit, filter, sort_by, **kwargs)  # noqa: E501

    @validate_arguments
    def list_transaction_templates_with_http_info(self, as_at : Annotated[Optional[datetime], Field(description="The AsAt time at which to retrieve the Transaction Templates")] = None, page : Annotated[Optional[constr(strict=True, max_length=500, min_length=1)], Field(description="The pagination token to use to continue listing Transaction Templates from a previous call to list Transaction Templates.              This value is returned from the previous call. If a pagination token is provided the sortBy, filter, limit, and asAt fields              must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True, le=5000, ge=1)], Field(description="When paginating, limit the number of returned results to this many.")] = None, filter : Annotated[Optional[constr(strict=True, max_length=16384, min_length=0)], Field(description="Expression to filter the result set. Read more about filtering results from LUSID here:              https://support.lusid.com/filtering-results-from-lusid.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names to sort by, each suffixed by \" ASC\" or \" DESC\"")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] ListTransactionTemplates: List Transaction Templates  # noqa: E501

        Lists all Transaction Templates.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_transaction_templates_with_http_info(as_at, page, limit, filter, sort_by, async_req=True)
        >>> result = thread.get()

        :param as_at: The AsAt time at which to retrieve the Transaction Templates
        :type as_at: datetime
        :param page: The pagination token to use to continue listing Transaction Templates from a previous call to list Transaction Templates.              This value is returned from the previous call. If a pagination token is provided the sortBy, filter, limit, and asAt fields              must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the number of returned results to this many.
        :type limit: int
        :param filter: Expression to filter the result set. Read more about filtering results from LUSID here:              https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param sort_by: A list of field names to sort by, each suffixed by \" ASC\" or \" DESC\"
        :type sort_by: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PagedResourceListOfTransactionTemplate, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'as_at',
            'page',
            'limit',
            'filter',
            'sort_by'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_transaction_templates" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        if _params.get('sort_by') is not None:  # noqa: E501
            _query_params.append(('sortBy', _params['sort_by']))
            _collection_formats['sortBy'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "PagedResourceListOfTransactionTemplate",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/instrumenteventtypes/transactiontemplates', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    async def update_transaction_template(self, instrument_event_type : Annotated[StrictStr, Field(..., description="The type of instrument events that the template is applied to.")], instrument_type : Annotated[StrictStr, Field(..., description="The instrument type of the transaction template. The combination of the instrument              event type, instrument type and scope uniquely identifies a transaction template")], scope : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The scope in which the template lies.")], transaction_template_request : Annotated[TransactionTemplateRequest, Field(..., description="A request defining the updated values for the transaction template.")], **kwargs) -> TransactionTemplate:  # noqa: E501
        ...

    @overload
    def update_transaction_template(self, instrument_event_type : Annotated[StrictStr, Field(..., description="The type of instrument events that the template is applied to.")], instrument_type : Annotated[StrictStr, Field(..., description="The instrument type of the transaction template. The combination of the instrument              event type, instrument type and scope uniquely identifies a transaction template")], scope : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The scope in which the template lies.")], transaction_template_request : Annotated[TransactionTemplateRequest, Field(..., description="A request defining the updated values for the transaction template.")], async_req: Optional[bool]=True, **kwargs) -> TransactionTemplate:  # noqa: E501
        ...

    @validate_arguments
    def update_transaction_template(self, instrument_event_type : Annotated[StrictStr, Field(..., description="The type of instrument events that the template is applied to.")], instrument_type : Annotated[StrictStr, Field(..., description="The instrument type of the transaction template. The combination of the instrument              event type, instrument type and scope uniquely identifies a transaction template")], scope : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The scope in which the template lies.")], transaction_template_request : Annotated[TransactionTemplateRequest, Field(..., description="A request defining the updated values for the transaction template.")], async_req: Optional[bool]=None, **kwargs) -> Union[TransactionTemplate, Awaitable[TransactionTemplate]]:  # noqa: E501
        """[EXPERIMENTAL] UpdateTransactionTemplate: Update Transaction Template  # noqa: E501

        Update a transaction template for a particular instrument event type in a scope.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_transaction_template(instrument_event_type, instrument_type, scope, transaction_template_request, async_req=True)
        >>> result = thread.get()

        :param instrument_event_type: The type of instrument events that the template is applied to. (required)
        :type instrument_event_type: str
        :param instrument_type: The instrument type of the transaction template. The combination of the instrument              event type, instrument type and scope uniquely identifies a transaction template (required)
        :type instrument_type: str
        :param scope: The scope in which the template lies. (required)
        :type scope: str
        :param transaction_template_request: A request defining the updated values for the transaction template. (required)
        :type transaction_template_request: TransactionTemplateRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TransactionTemplate
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the update_transaction_template_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.update_transaction_template_with_http_info(instrument_event_type, instrument_type, scope, transaction_template_request, **kwargs)  # noqa: E501

    @validate_arguments
    def update_transaction_template_with_http_info(self, instrument_event_type : Annotated[StrictStr, Field(..., description="The type of instrument events that the template is applied to.")], instrument_type : Annotated[StrictStr, Field(..., description="The instrument type of the transaction template. The combination of the instrument              event type, instrument type and scope uniquely identifies a transaction template")], scope : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The scope in which the template lies.")], transaction_template_request : Annotated[TransactionTemplateRequest, Field(..., description="A request defining the updated values for the transaction template.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] UpdateTransactionTemplate: Update Transaction Template  # noqa: E501

        Update a transaction template for a particular instrument event type in a scope.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_transaction_template_with_http_info(instrument_event_type, instrument_type, scope, transaction_template_request, async_req=True)
        >>> result = thread.get()

        :param instrument_event_type: The type of instrument events that the template is applied to. (required)
        :type instrument_event_type: str
        :param instrument_type: The instrument type of the transaction template. The combination of the instrument              event type, instrument type and scope uniquely identifies a transaction template (required)
        :type instrument_type: str
        :param scope: The scope in which the template lies. (required)
        :type scope: str
        :param transaction_template_request: A request defining the updated values for the transaction template. (required)
        :type transaction_template_request: TransactionTemplateRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(TransactionTemplate, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'instrument_event_type',
            'instrument_type',
            'scope',
            'transaction_template_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_transaction_template" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['instrument_event_type']:
            _path_params['instrumentEventType'] = _params['instrument_event_type']

        if _params['instrument_type']:
            _path_params['instrumentType'] = _params['instrument_type']

        if _params['scope']:
            _path_params['scope'] = _params['scope']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['transaction_template_request'] is not None:
            _body_params = _params['transaction_template_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "TransactionTemplate",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/instrumenteventtypes/{instrumentEventType}/transactiontemplates/{instrumentType}/{scope}', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
