# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic.v1 import validate_arguments, ValidationError
from typing import overload, Optional, Union, Awaitable

from typing_extensions import Annotated
from datetime import datetime

from pydantic.v1 import Field, StrictStr, conint, conlist, constr, validator

from typing import Optional

from lusid.models.create_risk_model_factor_set_request import CreateRiskModelFactorSetRequest
from lusid.models.deleted_entity_response import DeletedEntityResponse
from lusid.models.paged_resource_list_of_risk_model_factor_set import PagedResourceListOfRiskModelFactorSet
from lusid.models.risk_model_factor_set import RiskModelFactorSet
from lusid.models.update_risk_model_factor_set_request import UpdateRiskModelFactorSetRequest

from lusid.api_client import ApiClient
from lusid.api_response import ApiResponse
from lusid.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)
from lusid.extensions.configuration_options import ConfigurationOptions


class RiskModelFactorSetsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @overload
    async def create_risk_model_factor_set(self, create_risk_model_factor_set_request : Annotated[Optional[CreateRiskModelFactorSetRequest], Field(description="The request containing the details of the factor set")] = None, **kwargs) -> RiskModelFactorSet:  # noqa: E501
        ...

    @overload
    def create_risk_model_factor_set(self, create_risk_model_factor_set_request : Annotated[Optional[CreateRiskModelFactorSetRequest], Field(description="The request containing the details of the factor set")] = None, async_req: Optional[bool]=True, **kwargs) -> RiskModelFactorSet:  # noqa: E501
        ...

    @validate_arguments
    def create_risk_model_factor_set(self, create_risk_model_factor_set_request : Annotated[Optional[CreateRiskModelFactorSetRequest], Field(description="The request containing the details of the factor set")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[RiskModelFactorSet, Awaitable[RiskModelFactorSet]]:  # noqa: E501
        """[EXPERIMENTAL] CreateRiskModelFactorSet: Create a Factor Set  # noqa: E501

        Creates a factor set definition with a scoped Id and Name  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_risk_model_factor_set(create_risk_model_factor_set_request, async_req=True)
        >>> result = thread.get()

        :param create_risk_model_factor_set_request: The request containing the details of the factor set
        :type create_risk_model_factor_set_request: CreateRiskModelFactorSetRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: RiskModelFactorSet
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the create_risk_model_factor_set_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.create_risk_model_factor_set_with_http_info(create_risk_model_factor_set_request, **kwargs)  # noqa: E501

    @validate_arguments
    def create_risk_model_factor_set_with_http_info(self, create_risk_model_factor_set_request : Annotated[Optional[CreateRiskModelFactorSetRequest], Field(description="The request containing the details of the factor set")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] CreateRiskModelFactorSet: Create a Factor Set  # noqa: E501

        Creates a factor set definition with a scoped Id and Name  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_risk_model_factor_set_with_http_info(create_risk_model_factor_set_request, async_req=True)
        >>> result = thread.get()

        :param create_risk_model_factor_set_request: The request containing the details of the factor set
        :type create_risk_model_factor_set_request: CreateRiskModelFactorSetRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(RiskModelFactorSet, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'create_risk_model_factor_set_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_risk_model_factor_set" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['create_risk_model_factor_set_request'] is not None:
            _body_params = _params['create_risk_model_factor_set_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '201': "RiskModelFactorSet",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/riskmodels/factorsets', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    async def delete_risk_model_factor_set(self, scope : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The scope of the specified factor set.")], code : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The code of the specified factor set. Together with the domain and scope this uniquely              identifies the factor set.")], **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @overload
    def delete_risk_model_factor_set(self, scope : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The scope of the specified factor set.")], code : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The code of the specified factor set. Together with the domain and scope this uniquely              identifies the factor set.")], async_req: Optional[bool]=True, **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @validate_arguments
    def delete_risk_model_factor_set(self, scope : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The scope of the specified factor set.")], code : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The code of the specified factor set. Together with the domain and scope this uniquely              identifies the factor set.")], async_req: Optional[bool]=None, **kwargs) -> Union[DeletedEntityResponse, Awaitable[DeletedEntityResponse]]:  # noqa: E501
        """[EXPERIMENTAL] DeleteRiskModelFactorSet: Deletes a particular Factor Set  # noqa: E501

        The deletion will take effect from the factor set deletion datetime.  i.e. will no longer exist at any asAt datetime after the asAt datetime of deletion.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_risk_model_factor_set(scope, code, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the specified factor set. (required)
        :type scope: str
        :param code: The code of the specified factor set. Together with the domain and scope this uniquely              identifies the factor set. (required)
        :type code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DeletedEntityResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_risk_model_factor_set_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.delete_risk_model_factor_set_with_http_info(scope, code, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_risk_model_factor_set_with_http_info(self, scope : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The scope of the specified factor set.")], code : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The code of the specified factor set. Together with the domain and scope this uniquely              identifies the factor set.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] DeleteRiskModelFactorSet: Deletes a particular Factor Set  # noqa: E501

        The deletion will take effect from the factor set deletion datetime.  i.e. will no longer exist at any asAt datetime after the asAt datetime of deletion.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_risk_model_factor_set_with_http_info(scope, code, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the specified factor set. (required)
        :type scope: str
        :param code: The code of the specified factor set. Together with the domain and scope this uniquely              identifies the factor set. (required)
        :type code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DeletedEntityResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_risk_model_factor_set" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "DeletedEntityResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/riskmodels/factorsets/{scope}/{code}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    async def get_risk_model_factor_set(self, scope : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The scope of the specified factor set.")], code : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The code of the specified factor set. Together with the domain and scope this uniquely              identifies the factor set.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the factor set definition. Defaults to return              the latest version of the definition if not specified.")] = None, **kwargs) -> RiskModelFactorSet:  # noqa: E501
        ...

    @overload
    def get_risk_model_factor_set(self, scope : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The scope of the specified factor set.")], code : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The code of the specified factor set. Together with the domain and scope this uniquely              identifies the factor set.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the factor set definition. Defaults to return              the latest version of the definition if not specified.")] = None, async_req: Optional[bool]=True, **kwargs) -> RiskModelFactorSet:  # noqa: E501
        ...

    @validate_arguments
    def get_risk_model_factor_set(self, scope : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The scope of the specified factor set.")], code : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The code of the specified factor set. Together with the domain and scope this uniquely              identifies the factor set.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the factor set definition. Defaults to return              the latest version of the definition if not specified.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[RiskModelFactorSet, Awaitable[RiskModelFactorSet]]:  # noqa: E501
        """[EXPERIMENTAL] GetRiskModelFactorSet: Get a single Factor Set by scope and code.  # noqa: E501

        Retrieves one Factor Set by scope and code.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_risk_model_factor_set(scope, code, as_at, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the specified factor set. (required)
        :type scope: str
        :param code: The code of the specified factor set. Together with the domain and scope this uniquely              identifies the factor set. (required)
        :type code: str
        :param as_at: The asAt datetime at which to retrieve the factor set definition. Defaults to return              the latest version of the definition if not specified.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: RiskModelFactorSet
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_risk_model_factor_set_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_risk_model_factor_set_with_http_info(scope, code, as_at, **kwargs)  # noqa: E501

    @validate_arguments
    def get_risk_model_factor_set_with_http_info(self, scope : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The scope of the specified factor set.")], code : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The code of the specified factor set. Together with the domain and scope this uniquely              identifies the factor set.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the factor set definition. Defaults to return              the latest version of the definition if not specified.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] GetRiskModelFactorSet: Get a single Factor Set by scope and code.  # noqa: E501

        Retrieves one Factor Set by scope and code.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_risk_model_factor_set_with_http_info(scope, code, as_at, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the specified factor set. (required)
        :type scope: str
        :param code: The code of the specified factor set. Together with the domain and scope this uniquely              identifies the factor set. (required)
        :type code: str
        :param as_at: The asAt datetime at which to retrieve the factor set definition. Defaults to return              the latest version of the definition if not specified.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(RiskModelFactorSet, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'as_at'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_risk_model_factor_set" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "RiskModelFactorSet",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/riskmodels/factorsets/{scope}/{code}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    async def list_risk_model_factor_sets(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the factor sets. Defaults to return the latest              version of the factor sets if not specified.")] = None, page : Annotated[Optional[constr(strict=True, max_length=500, min_length=1)], Field(description="The pagination token to use to continue listing factor sets from a previous call to list              factor sets. This value is returned from the previous call. If a pagination token is provided the sortBy,              filter, effectiveAt, and asAt fields must not have changed since the original request.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names to sort by, each suffixed by \" ASC\" or \" DESC\"")] = None, limit : Annotated[Optional[conint(strict=True, le=5000, ge=1)], Field(description="Page size.")] = None, filter : Annotated[Optional[constr(strict=True, max_length=16384, min_length=0)], Field(description="Expression to filter the result set. Read more about filtering results from LUSID here:              https://support.lusid.com/filtering-results-from-lusid.")] = None, **kwargs) -> PagedResourceListOfRiskModelFactorSet:  # noqa: E501
        ...

    @overload
    def list_risk_model_factor_sets(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the factor sets. Defaults to return the latest              version of the factor sets if not specified.")] = None, page : Annotated[Optional[constr(strict=True, max_length=500, min_length=1)], Field(description="The pagination token to use to continue listing factor sets from a previous call to list              factor sets. This value is returned from the previous call. If a pagination token is provided the sortBy,              filter, effectiveAt, and asAt fields must not have changed since the original request.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names to sort by, each suffixed by \" ASC\" or \" DESC\"")] = None, limit : Annotated[Optional[conint(strict=True, le=5000, ge=1)], Field(description="Page size.")] = None, filter : Annotated[Optional[constr(strict=True, max_length=16384, min_length=0)], Field(description="Expression to filter the result set. Read more about filtering results from LUSID here:              https://support.lusid.com/filtering-results-from-lusid.")] = None, async_req: Optional[bool]=True, **kwargs) -> PagedResourceListOfRiskModelFactorSet:  # noqa: E501
        ...

    @validate_arguments
    def list_risk_model_factor_sets(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the factor sets. Defaults to return the latest              version of the factor sets if not specified.")] = None, page : Annotated[Optional[constr(strict=True, max_length=500, min_length=1)], Field(description="The pagination token to use to continue listing factor sets from a previous call to list              factor sets. This value is returned from the previous call. If a pagination token is provided the sortBy,              filter, effectiveAt, and asAt fields must not have changed since the original request.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names to sort by, each suffixed by \" ASC\" or \" DESC\"")] = None, limit : Annotated[Optional[conint(strict=True, le=5000, ge=1)], Field(description="Page size.")] = None, filter : Annotated[Optional[constr(strict=True, max_length=16384, min_length=0)], Field(description="Expression to filter the result set. Read more about filtering results from LUSID here:              https://support.lusid.com/filtering-results-from-lusid.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[PagedResourceListOfRiskModelFactorSet, Awaitable[PagedResourceListOfRiskModelFactorSet]]:  # noqa: E501
        """[EXPERIMENTAL] ListRiskModelFactorSets: Get a set of Factor Sets  # noqa: E501

        Retrieves all Factor Sets (without related Factors) that fit the filter, in a specific order if sortBy is provided.  Supports pagination  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_risk_model_factor_sets(as_at, page, sort_by, limit, filter, async_req=True)
        >>> result = thread.get()

        :param as_at: The asAt datetime at which to retrieve the factor sets. Defaults to return the latest              version of the factor sets if not specified.
        :type as_at: datetime
        :param page: The pagination token to use to continue listing factor sets from a previous call to list              factor sets. This value is returned from the previous call. If a pagination token is provided the sortBy,              filter, effectiveAt, and asAt fields must not have changed since the original request.
        :type page: str
        :param sort_by: A list of field names to sort by, each suffixed by \" ASC\" or \" DESC\"
        :type sort_by: List[str]
        :param limit: Page size.
        :type limit: int
        :param filter: Expression to filter the result set. Read more about filtering results from LUSID here:              https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PagedResourceListOfRiskModelFactorSet
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_risk_model_factor_sets_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.list_risk_model_factor_sets_with_http_info(as_at, page, sort_by, limit, filter, **kwargs)  # noqa: E501

    @validate_arguments
    def list_risk_model_factor_sets_with_http_info(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the factor sets. Defaults to return the latest              version of the factor sets if not specified.")] = None, page : Annotated[Optional[constr(strict=True, max_length=500, min_length=1)], Field(description="The pagination token to use to continue listing factor sets from a previous call to list              factor sets. This value is returned from the previous call. If a pagination token is provided the sortBy,              filter, effectiveAt, and asAt fields must not have changed since the original request.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names to sort by, each suffixed by \" ASC\" or \" DESC\"")] = None, limit : Annotated[Optional[conint(strict=True, le=5000, ge=1)], Field(description="Page size.")] = None, filter : Annotated[Optional[constr(strict=True, max_length=16384, min_length=0)], Field(description="Expression to filter the result set. Read more about filtering results from LUSID here:              https://support.lusid.com/filtering-results-from-lusid.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] ListRiskModelFactorSets: Get a set of Factor Sets  # noqa: E501

        Retrieves all Factor Sets (without related Factors) that fit the filter, in a specific order if sortBy is provided.  Supports pagination  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_risk_model_factor_sets_with_http_info(as_at, page, sort_by, limit, filter, async_req=True)
        >>> result = thread.get()

        :param as_at: The asAt datetime at which to retrieve the factor sets. Defaults to return the latest              version of the factor sets if not specified.
        :type as_at: datetime
        :param page: The pagination token to use to continue listing factor sets from a previous call to list              factor sets. This value is returned from the previous call. If a pagination token is provided the sortBy,              filter, effectiveAt, and asAt fields must not have changed since the original request.
        :type page: str
        :param sort_by: A list of field names to sort by, each suffixed by \" ASC\" or \" DESC\"
        :type sort_by: List[str]
        :param limit: Page size.
        :type limit: int
        :param filter: Expression to filter the result set. Read more about filtering results from LUSID here:              https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PagedResourceListOfRiskModelFactorSet, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'as_at',
            'page',
            'sort_by',
            'limit',
            'filter'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_risk_model_factor_sets" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('sort_by') is not None:  # noqa: E501
            _query_params.append(('sortBy', _params['sort_by']))
            _collection_formats['sortBy'] = 'multi'

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "PagedResourceListOfRiskModelFactorSet",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/riskmodels/factorsets', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    async def update_risk_model_factor_set_name(self, scope : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The scope of the specified factor set.")], code : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The code of the specified factor set. Together with the domain and scope this uniquely              identifies the factor set.")], update_risk_model_factor_set_request : Annotated[Optional[UpdateRiskModelFactorSetRequest], Field(description="The request containing the updated name of the factor set.")] = None, **kwargs) -> RiskModelFactorSet:  # noqa: E501
        ...

    @overload
    def update_risk_model_factor_set_name(self, scope : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The scope of the specified factor set.")], code : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The code of the specified factor set. Together with the domain and scope this uniquely              identifies the factor set.")], update_risk_model_factor_set_request : Annotated[Optional[UpdateRiskModelFactorSetRequest], Field(description="The request containing the updated name of the factor set.")] = None, async_req: Optional[bool]=True, **kwargs) -> RiskModelFactorSet:  # noqa: E501
        ...

    @validate_arguments
    def update_risk_model_factor_set_name(self, scope : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The scope of the specified factor set.")], code : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The code of the specified factor set. Together with the domain and scope this uniquely              identifies the factor set.")], update_risk_model_factor_set_request : Annotated[Optional[UpdateRiskModelFactorSetRequest], Field(description="The request containing the updated name of the factor set.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[RiskModelFactorSet, Awaitable[RiskModelFactorSet]]:  # noqa: E501
        """[EXPERIMENTAL] UpdateRiskModelFactorSetName: Update Factor Set Display Name  # noqa: E501

        Overwrites an existing Factor Set as per scope and code from the route  Update request has a single property - DisplayName  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_risk_model_factor_set_name(scope, code, update_risk_model_factor_set_request, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the specified factor set. (required)
        :type scope: str
        :param code: The code of the specified factor set. Together with the domain and scope this uniquely              identifies the factor set. (required)
        :type code: str
        :param update_risk_model_factor_set_request: The request containing the updated name of the factor set.
        :type update_risk_model_factor_set_request: UpdateRiskModelFactorSetRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: RiskModelFactorSet
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the update_risk_model_factor_set_name_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.update_risk_model_factor_set_name_with_http_info(scope, code, update_risk_model_factor_set_request, **kwargs)  # noqa: E501

    @validate_arguments
    def update_risk_model_factor_set_name_with_http_info(self, scope : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The scope of the specified factor set.")], code : Annotated[constr(strict=True, max_length=64, min_length=1), Field(..., description="The code of the specified factor set. Together with the domain and scope this uniquely              identifies the factor set.")], update_risk_model_factor_set_request : Annotated[Optional[UpdateRiskModelFactorSetRequest], Field(description="The request containing the updated name of the factor set.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] UpdateRiskModelFactorSetName: Update Factor Set Display Name  # noqa: E501

        Overwrites an existing Factor Set as per scope and code from the route  Update request has a single property - DisplayName  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_risk_model_factor_set_name_with_http_info(scope, code, update_risk_model_factor_set_request, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the specified factor set. (required)
        :type scope: str
        :param code: The code of the specified factor set. Together with the domain and scope this uniquely              identifies the factor set. (required)
        :type code: str
        :param update_risk_model_factor_set_request: The request containing the updated name of the factor set.
        :type update_risk_model_factor_set_request: UpdateRiskModelFactorSetRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(RiskModelFactorSet, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'update_risk_model_factor_set_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_risk_model_factor_set_name" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['update_risk_model_factor_set_request'] is not None:
            _body_params = _params['update_risk_model_factor_set_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "RiskModelFactorSet",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/riskmodels/factorsets/{scope}/{code}', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
