# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic.v1 import validate_arguments, ValidationError
from typing import overload, Optional, Union, Awaitable

from typing_extensions import Annotated
from pydantic.v1 import Field

from lusid.models.translate_instrument_definitions_request import TranslateInstrumentDefinitionsRequest
from lusid.models.translate_instrument_definitions_response import TranslateInstrumentDefinitionsResponse
from lusid.models.translate_trade_ticket_request import TranslateTradeTicketRequest
from lusid.models.translate_trade_tickets_response import TranslateTradeTicketsResponse

from lusid.api_client import ApiClient
from lusid.api_response import ApiResponse
from lusid.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)
from lusid.extensions.configuration_options import ConfigurationOptions


class TranslationApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @overload
    async def translate_instrument_definitions(self, translate_instrument_definitions_request : Annotated[TranslateInstrumentDefinitionsRequest, Field(..., description="The definitions of the instruments to translate along with the target dialect.")], **kwargs) -> TranslateInstrumentDefinitionsResponse:  # noqa: E501
        ...

    @overload
    def translate_instrument_definitions(self, translate_instrument_definitions_request : Annotated[TranslateInstrumentDefinitionsRequest, Field(..., description="The definitions of the instruments to translate along with the target dialect.")], async_req: Optional[bool]=True, **kwargs) -> TranslateInstrumentDefinitionsResponse:  # noqa: E501
        ...

    @validate_arguments
    def translate_instrument_definitions(self, translate_instrument_definitions_request : Annotated[TranslateInstrumentDefinitionsRequest, Field(..., description="The definitions of the instruments to translate along with the target dialect.")], async_req: Optional[bool]=None, **kwargs) -> Union[TranslateInstrumentDefinitionsResponse, Awaitable[TranslateInstrumentDefinitionsResponse]]:  # noqa: E501
        """[EXPERIMENTAL] TranslateInstrumentDefinitions: Translate instruments  # noqa: E501

        Translates one or more instruments into the given target dialect.                In the request each instrument definition should be keyed by a unique correlation id. This id is ephemeral  and is not stored by LUSID. It serves only as a way to easily identify each instrument in the response.                Any instrument that is not already in the LUSID dialect should be given as an ExoticInstrument.                The response will return both the collection of successfully translated instruments in the target dialect,  as well as those that failed.  For the failures a reason will be provided explaining why the instrument could not be updated or inserted.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.translate_instrument_definitions(translate_instrument_definitions_request, async_req=True)
        >>> result = thread.get()

        :param translate_instrument_definitions_request: The definitions of the instruments to translate along with the target dialect. (required)
        :type translate_instrument_definitions_request: TranslateInstrumentDefinitionsRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TranslateInstrumentDefinitionsResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the translate_instrument_definitions_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.translate_instrument_definitions_with_http_info(translate_instrument_definitions_request, **kwargs)  # noqa: E501

    @validate_arguments
    def translate_instrument_definitions_with_http_info(self, translate_instrument_definitions_request : Annotated[TranslateInstrumentDefinitionsRequest, Field(..., description="The definitions of the instruments to translate along with the target dialect.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] TranslateInstrumentDefinitions: Translate instruments  # noqa: E501

        Translates one or more instruments into the given target dialect.                In the request each instrument definition should be keyed by a unique correlation id. This id is ephemeral  and is not stored by LUSID. It serves only as a way to easily identify each instrument in the response.                Any instrument that is not already in the LUSID dialect should be given as an ExoticInstrument.                The response will return both the collection of successfully translated instruments in the target dialect,  as well as those that failed.  For the failures a reason will be provided explaining why the instrument could not be updated or inserted.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.translate_instrument_definitions_with_http_info(translate_instrument_definitions_request, async_req=True)
        >>> result = thread.get()

        :param translate_instrument_definitions_request: The definitions of the instruments to translate along with the target dialect. (required)
        :type translate_instrument_definitions_request: TranslateInstrumentDefinitionsRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(TranslateInstrumentDefinitionsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'translate_instrument_definitions_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method translate_instrument_definitions" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['translate_instrument_definitions_request'] is not None:
            _body_params = _params['translate_instrument_definitions_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "TranslateInstrumentDefinitionsResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/translation/instrumentdefinitions', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    async def translate_trade_tickets(self, translate_trade_ticket_request : Annotated[TranslateTradeTicketRequest, Field(..., description="The definitions of the trade ticket to translate along with the target dialect.")], **kwargs) -> TranslateTradeTicketsResponse:  # noqa: E501
        ...

    @overload
    def translate_trade_tickets(self, translate_trade_ticket_request : Annotated[TranslateTradeTicketRequest, Field(..., description="The definitions of the trade ticket to translate along with the target dialect.")], async_req: Optional[bool]=True, **kwargs) -> TranslateTradeTicketsResponse:  # noqa: E501
        ...

    @validate_arguments
    def translate_trade_tickets(self, translate_trade_ticket_request : Annotated[TranslateTradeTicketRequest, Field(..., description="The definitions of the trade ticket to translate along with the target dialect.")], async_req: Optional[bool]=None, **kwargs) -> Union[TranslateTradeTicketsResponse, Awaitable[TranslateTradeTicketsResponse]]:  # noqa: E501
        """[EXPERIMENTAL] TranslateTradeTickets: Translate trade ticket  # noqa: E501

        Translates one or more trade tickets into the given target dialect.                In the request each trade ticket definition should be keyed by a unique correlation id. This id is ephemeral  and is not stored by LUSID. It serves only as a way to easily identify each trade ticket in the response.                The response will return both the collection of successfully translated trade tickets in the target dialect,  as well as those that failed.  For the failures a reason will be provided explaining why the trade ticket could not be updated or inserted.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.translate_trade_tickets(translate_trade_ticket_request, async_req=True)
        >>> result = thread.get()

        :param translate_trade_ticket_request: The definitions of the trade ticket to translate along with the target dialect. (required)
        :type translate_trade_ticket_request: TranslateTradeTicketRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TranslateTradeTicketsResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the translate_trade_tickets_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.translate_trade_tickets_with_http_info(translate_trade_ticket_request, **kwargs)  # noqa: E501

    @validate_arguments
    def translate_trade_tickets_with_http_info(self, translate_trade_ticket_request : Annotated[TranslateTradeTicketRequest, Field(..., description="The definitions of the trade ticket to translate along with the target dialect.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] TranslateTradeTickets: Translate trade ticket  # noqa: E501

        Translates one or more trade tickets into the given target dialect.                In the request each trade ticket definition should be keyed by a unique correlation id. This id is ephemeral  and is not stored by LUSID. It serves only as a way to easily identify each trade ticket in the response.                The response will return both the collection of successfully translated trade tickets in the target dialect,  as well as those that failed.  For the failures a reason will be provided explaining why the trade ticket could not be updated or inserted.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.translate_trade_tickets_with_http_info(translate_trade_ticket_request, async_req=True)
        >>> result = thread.get()

        :param translate_trade_ticket_request: The definitions of the trade ticket to translate along with the target dialect. (required)
        :type translate_trade_ticket_request: TranslateTradeTicketRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(TranslateTradeTicketsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'translate_trade_ticket_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method translate_trade_tickets" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['translate_trade_ticket_request'] is not None:
            _body_params = _params['translate_trade_ticket_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "TranslateTradeTicketsResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/translation/tradetickets', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
