# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional
from pydantic.v1 import BaseModel, Field, conlist
from lusid.models.allocation_request import AllocationRequest

class AllocationSetRequest(BaseModel):
    """
    A request to create or update multiple Allocations.  # noqa: E501
    """
    allocation_requests: Optional[conlist(AllocationRequest)] = Field(None, alias="allocationRequests", description="A collection of AllocationRequests.")
    __properties = ["allocationRequests"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AllocationSetRequest:
        """Create an instance of AllocationSetRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in allocation_requests (list)
        _items = []
        if self.allocation_requests:
            for _item in self.allocation_requests:
                if _item:
                    _items.append(_item.to_dict())
            _dict['allocationRequests'] = _items
        # set to None if allocation_requests (nullable) is None
        # and __fields_set__ contains the field
        if self.allocation_requests is None and "allocation_requests" in self.__fields_set__:
            _dict['allocationRequests'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AllocationSetRequest:
        """Create an instance of AllocationSetRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return AllocationSetRequest.parse_obj(obj)

        _obj = AllocationSetRequest.parse_obj({
            "allocation_requests": [AllocationRequest.from_dict(_item) for _item in obj.get("allocationRequests")] if obj.get("allocationRequests") is not None else None
        })
        return _obj
