# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, Optional
from pydantic.v1 import BaseModel, Field, StrictStr, constr
from lusid.models.date_attributes import DateAttributes

class CalendarDate(BaseModel):
    """
    CalendarDate
    """
    href: Optional[StrictStr] = None
    date_identifier: constr(strict=True, min_length=1) = Field(..., alias="dateIdentifier")
    from_utc: datetime = Field(..., alias="fromUtc")
    to_utc: datetime = Field(..., alias="toUtc")
    local_date: constr(strict=True, min_length=1) = Field(..., alias="localDate")
    timezone: constr(strict=True, min_length=1) = Field(...)
    description: constr(strict=True, min_length=1) = Field(...)
    type: constr(strict=True, min_length=1) = Field(...)
    attributes: Optional[DateAttributes] = None
    source_data: Optional[Dict[str, StrictStr]] = Field(None, alias="sourceData")
    __properties = ["href", "dateIdentifier", "fromUtc", "toUtc", "localDate", "timezone", "description", "type", "attributes", "sourceData"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CalendarDate:
        """Create an instance of CalendarDate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of attributes
        if self.attributes:
            _dict['attributes'] = self.attributes.to_dict()
        # set to None if href (nullable) is None
        # and __fields_set__ contains the field
        if self.href is None and "href" in self.__fields_set__:
            _dict['href'] = None

        # set to None if source_data (nullable) is None
        # and __fields_set__ contains the field
        if self.source_data is None and "source_data" in self.__fields_set__:
            _dict['sourceData'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CalendarDate:
        """Create an instance of CalendarDate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CalendarDate.parse_obj(obj)

        _obj = CalendarDate.parse_obj({
            "href": obj.get("href"),
            "date_identifier": obj.get("dateIdentifier"),
            "from_utc": obj.get("fromUtc"),
            "to_utc": obj.get("toUtc"),
            "local_date": obj.get("localDate"),
            "timezone": obj.get("timezone"),
            "description": obj.get("description"),
            "type": obj.get("type"),
            "attributes": DateAttributes.from_dict(obj.get("attributes")) if obj.get("attributes") is not None else None,
            "source_data": obj.get("sourceData")
        })
        return _obj
