# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, List, Optional, Union
from pydantic.v1 import Field, StrictFloat, StrictInt, StrictStr, conlist, validator
from lusid.models.instrument_event import InstrumentEvent
from lusid.models.lapse_election import LapseElection
from lusid.models.new_instrument import NewInstrument
from lusid.models.option_exercise_election import OptionExerciseElection
from lusid.models.units_ratio import UnitsRatio

class CallOnIntermediateSecuritiesEvent(InstrumentEvent):
    """
    CallOnIntermediateSecuritiesEvent event (EXRI), representing an exercise on intermediate securities resulting from an intermediate securities distribution.  # noqa: E501
    """
    expiry_date: datetime = Field(..., alias="expiryDate", description="The date on which the issue ends.")
    payment_date: datetime = Field(..., alias="paymentDate", description="The payment date of the event.")
    new_instrument: NewInstrument = Field(..., alias="newInstrument")
    units_ratio: UnitsRatio = Field(..., alias="unitsRatio")
    price: Union[StrictFloat, StrictInt] = Field(..., description="The price at which new units are purchased.")
    exercise_currency: StrictStr = Field(..., alias="exerciseCurrency", description="The currency of the exercise.")
    option_exercise_elections: Optional[conlist(OptionExerciseElection)] = Field(None, alias="optionExerciseElections", description="Option exercise election for this event.")
    lapse_elections: Optional[conlist(LapseElection)] = Field(None, alias="lapseElections", description="Lapse election for this event.")
    instrument_event_type: StrictStr = Field(..., alias="instrumentEventType", description="The Type of Event. The available values are: TransitionEvent, InformationalEvent, OpenEvent, CloseEvent, StockSplitEvent, BondDefaultEvent, CashDividendEvent, AmortisationEvent, CashFlowEvent, ExerciseEvent, ResetEvent, TriggerEvent, RawVendorEvent, InformationalErrorEvent, BondCouponEvent, DividendReinvestmentEvent, AccumulationEvent, BondPrincipalEvent, DividendOptionEvent, MaturityEvent, FxForwardSettlementEvent, ExpiryEvent, ScripDividendEvent, StockDividendEvent, ReverseStockSplitEvent, CapitalDistributionEvent, SpinOffEvent, MergerEvent, FutureExpiryEvent, SwapCashFlowEvent, SwapPrincipalEvent, CreditPremiumCashFlowEvent, CdsCreditEvent, CdxCreditEvent, MbsCouponEvent, MbsPrincipalEvent, BonusIssueEvent, MbsPrincipalWriteOffEvent, MbsInterestDeferralEvent, MbsInterestShortfallEvent, TenderEvent, CallOnIntermediateSecuritiesEvent, IntermediateSecuritiesDistributionEvent, OptionExercisePhysicalEvent, OptionExerciseCashEvent, ProtectionPayoutCashFlowEvent, TermDepositInterestEvent, TermDepositPrincipalEvent, EarlyRedemptionEvent, FutureMarkToMarketEvent, AdjustGlobalCommitmentEvent, ContractInitialisationEvent, DrawdownEvent")
    additional_properties: Dict[str, Any] = {}
    __properties = ["instrumentEventType", "expiryDate", "paymentDate", "newInstrument", "unitsRatio", "price", "exerciseCurrency", "optionExerciseElections", "lapseElections"]

    @validator('instrument_event_type')
    def instrument_event_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('TransitionEvent', 'InformationalEvent', 'OpenEvent', 'CloseEvent', 'StockSplitEvent', 'BondDefaultEvent', 'CashDividendEvent', 'AmortisationEvent', 'CashFlowEvent', 'ExerciseEvent', 'ResetEvent', 'TriggerEvent', 'RawVendorEvent', 'InformationalErrorEvent', 'BondCouponEvent', 'DividendReinvestmentEvent', 'AccumulationEvent', 'BondPrincipalEvent', 'DividendOptionEvent', 'MaturityEvent', 'FxForwardSettlementEvent', 'ExpiryEvent', 'ScripDividendEvent', 'StockDividendEvent', 'ReverseStockSplitEvent', 'CapitalDistributionEvent', 'SpinOffEvent', 'MergerEvent', 'FutureExpiryEvent', 'SwapCashFlowEvent', 'SwapPrincipalEvent', 'CreditPremiumCashFlowEvent', 'CdsCreditEvent', 'CdxCreditEvent', 'MbsCouponEvent', 'MbsPrincipalEvent', 'BonusIssueEvent', 'MbsPrincipalWriteOffEvent', 'MbsInterestDeferralEvent', 'MbsInterestShortfallEvent', 'TenderEvent', 'CallOnIntermediateSecuritiesEvent', 'IntermediateSecuritiesDistributionEvent', 'OptionExercisePhysicalEvent', 'OptionExerciseCashEvent', 'ProtectionPayoutCashFlowEvent', 'TermDepositInterestEvent', 'TermDepositPrincipalEvent', 'EarlyRedemptionEvent', 'FutureMarkToMarketEvent', 'AdjustGlobalCommitmentEvent', 'ContractInitialisationEvent', 'DrawdownEvent'):
            raise ValueError("must be one of enum values ('TransitionEvent', 'InformationalEvent', 'OpenEvent', 'CloseEvent', 'StockSplitEvent', 'BondDefaultEvent', 'CashDividendEvent', 'AmortisationEvent', 'CashFlowEvent', 'ExerciseEvent', 'ResetEvent', 'TriggerEvent', 'RawVendorEvent', 'InformationalErrorEvent', 'BondCouponEvent', 'DividendReinvestmentEvent', 'AccumulationEvent', 'BondPrincipalEvent', 'DividendOptionEvent', 'MaturityEvent', 'FxForwardSettlementEvent', 'ExpiryEvent', 'ScripDividendEvent', 'StockDividendEvent', 'ReverseStockSplitEvent', 'CapitalDistributionEvent', 'SpinOffEvent', 'MergerEvent', 'FutureExpiryEvent', 'SwapCashFlowEvent', 'SwapPrincipalEvent', 'CreditPremiumCashFlowEvent', 'CdsCreditEvent', 'CdxCreditEvent', 'MbsCouponEvent', 'MbsPrincipalEvent', 'BonusIssueEvent', 'MbsPrincipalWriteOffEvent', 'MbsInterestDeferralEvent', 'MbsInterestShortfallEvent', 'TenderEvent', 'CallOnIntermediateSecuritiesEvent', 'IntermediateSecuritiesDistributionEvent', 'OptionExercisePhysicalEvent', 'OptionExerciseCashEvent', 'ProtectionPayoutCashFlowEvent', 'TermDepositInterestEvent', 'TermDepositPrincipalEvent', 'EarlyRedemptionEvent', 'FutureMarkToMarketEvent', 'AdjustGlobalCommitmentEvent', 'ContractInitialisationEvent', 'DrawdownEvent')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CallOnIntermediateSecuritiesEvent:
        """Create an instance of CallOnIntermediateSecuritiesEvent from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "additional_properties"
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of new_instrument
        if self.new_instrument:
            _dict['newInstrument'] = self.new_instrument.to_dict()
        # override the default output from pydantic by calling `to_dict()` of units_ratio
        if self.units_ratio:
            _dict['unitsRatio'] = self.units_ratio.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in option_exercise_elections (list)
        _items = []
        if self.option_exercise_elections:
            for _item in self.option_exercise_elections:
                if _item:
                    _items.append(_item.to_dict())
            _dict['optionExerciseElections'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in lapse_elections (list)
        _items = []
        if self.lapse_elections:
            for _item in self.lapse_elections:
                if _item:
                    _items.append(_item.to_dict())
            _dict['lapseElections'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if option_exercise_elections (nullable) is None
        # and __fields_set__ contains the field
        if self.option_exercise_elections is None and "option_exercise_elections" in self.__fields_set__:
            _dict['optionExerciseElections'] = None

        # set to None if lapse_elections (nullable) is None
        # and __fields_set__ contains the field
        if self.lapse_elections is None and "lapse_elections" in self.__fields_set__:
            _dict['lapseElections'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CallOnIntermediateSecuritiesEvent:
        """Create an instance of CallOnIntermediateSecuritiesEvent from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CallOnIntermediateSecuritiesEvent.parse_obj(obj)

        _obj = CallOnIntermediateSecuritiesEvent.parse_obj({
            "instrument_event_type": obj.get("instrumentEventType"),
            "expiry_date": obj.get("expiryDate"),
            "payment_date": obj.get("paymentDate"),
            "new_instrument": NewInstrument.from_dict(obj.get("newInstrument")) if obj.get("newInstrument") is not None else None,
            "units_ratio": UnitsRatio.from_dict(obj.get("unitsRatio")) if obj.get("unitsRatio") is not None else None,
            "price": obj.get("price"),
            "exercise_currency": obj.get("exerciseCurrency"),
            "option_exercise_elections": [OptionExerciseElection.from_dict(_item) for _item in obj.get("optionExerciseElections")] if obj.get("optionExerciseElections") is not None else None,
            "lapse_elections": [LapseElection.from_dict(_item) for _item in obj.get("lapseElections")] if obj.get("lapseElections") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj
