# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional, Union
from pydantic.v1 import BaseModel, Field, StrictBool, StrictFloat, StrictInt, StrictStr, constr
from lusid.models.units_ratio import UnitsRatio

class CashAndSecurityOfferElection(BaseModel):
    """
      # noqa: E501
    """
    cash_offer_currency: StrictStr = Field(..., alias="cashOfferCurrency", description="Currency of the cash offer")
    cash_offer_price: Union[StrictFloat, StrictInt] = Field(..., alias="cashOfferPrice", description="Price per share of the cash offer")
    cost_factor: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="costFactor", description="Optional. The fraction of cost that is transferred from the existing shares to the new shares.")
    election_key: constr(strict=True, min_length=1) = Field(..., alias="electionKey", description="Unique key associated to this election.")
    is_chosen: Optional[StrictBool] = Field(None, alias="isChosen", description="Is this the election that has been explicitly chosen from multiple options.")
    is_default: Optional[StrictBool] = Field(None, alias="isDefault", description="Is this election automatically applied in the absence of an election having been made.  May only be true for one election if multiple are provided.")
    units_ratio: UnitsRatio = Field(..., alias="unitsRatio")
    __properties = ["cashOfferCurrency", "cashOfferPrice", "costFactor", "electionKey", "isChosen", "isDefault", "unitsRatio"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CashAndSecurityOfferElection:
        """Create an instance of CashAndSecurityOfferElection from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of units_ratio
        if self.units_ratio:
            _dict['unitsRatio'] = self.units_ratio.to_dict()
        # set to None if cost_factor (nullable) is None
        # and __fields_set__ contains the field
        if self.cost_factor is None and "cost_factor" in self.__fields_set__:
            _dict['costFactor'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CashAndSecurityOfferElection:
        """Create an instance of CashAndSecurityOfferElection from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CashAndSecurityOfferElection.parse_obj(obj)

        _obj = CashAndSecurityOfferElection.parse_obj({
            "cash_offer_currency": obj.get("cashOfferCurrency"),
            "cash_offer_price": obj.get("cashOfferPrice"),
            "cost_factor": obj.get("costFactor"),
            "election_key": obj.get("electionKey"),
            "is_chosen": obj.get("isChosen"),
            "is_default": obj.get("isDefault"),
            "units_ratio": UnitsRatio.from_dict(obj.get("unitsRatio")) if obj.get("unitsRatio") is not None else None
        })
        return _obj
