# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, Optional
from pydantic.v1 import BaseModel, Field, StrictStr, constr
from lusid.models.related_entity import RelatedEntity
from lusid.models.resource_id import ResourceId
from lusid.models.version import Version

class CompleteRelationship(BaseModel):
    """
    Representation of a relationship containing details of source and target entities, and both outward and inward descriptions.  # noqa: E501
    """
    href: Optional[StrictStr] = Field(None, description="The specific Uniform Resource Identifier (URI) for this resource at the requested effective and asAt datetime.")
    version: Optional[Version] = None
    relationship_definition_id: ResourceId = Field(..., alias="relationshipDefinitionId")
    source_entity: RelatedEntity = Field(..., alias="sourceEntity")
    target_entity: RelatedEntity = Field(..., alias="targetEntity")
    outward_description: constr(strict=True, min_length=1) = Field(..., alias="outwardDescription", description="Description of the relationship based on relationship definition's outward description.")
    inward_description: constr(strict=True, min_length=1) = Field(..., alias="inwardDescription", description="Description of the relationship based on relationship definition's inward description.")
    effective_from: Optional[datetime] = Field(None, alias="effectiveFrom", description="The effective datetime from which the relationship is valid.")
    effective_until: Optional[datetime] = Field(None, alias="effectiveUntil", description="The effective datetime to which the relationship is valid until.")
    __properties = ["href", "version", "relationshipDefinitionId", "sourceEntity", "targetEntity", "outwardDescription", "inwardDescription", "effectiveFrom", "effectiveUntil"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CompleteRelationship:
        """Create an instance of CompleteRelationship from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of version
        if self.version:
            _dict['version'] = self.version.to_dict()
        # override the default output from pydantic by calling `to_dict()` of relationship_definition_id
        if self.relationship_definition_id:
            _dict['relationshipDefinitionId'] = self.relationship_definition_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of source_entity
        if self.source_entity:
            _dict['sourceEntity'] = self.source_entity.to_dict()
        # override the default output from pydantic by calling `to_dict()` of target_entity
        if self.target_entity:
            _dict['targetEntity'] = self.target_entity.to_dict()
        # set to None if href (nullable) is None
        # and __fields_set__ contains the field
        if self.href is None and "href" in self.__fields_set__:
            _dict['href'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CompleteRelationship:
        """Create an instance of CompleteRelationship from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CompleteRelationship.parse_obj(obj)

        _obj = CompleteRelationship.parse_obj({
            "href": obj.get("href"),
            "version": Version.from_dict(obj.get("version")) if obj.get("version") is not None else None,
            "relationship_definition_id": ResourceId.from_dict(obj.get("relationshipDefinitionId")) if obj.get("relationshipDefinitionId") is not None else None,
            "source_entity": RelatedEntity.from_dict(obj.get("sourceEntity")) if obj.get("sourceEntity") is not None else None,
            "target_entity": RelatedEntity.from_dict(obj.get("targetEntity")) if obj.get("targetEntity") is not None else None,
            "outward_description": obj.get("outwardDescription"),
            "inward_description": obj.get("inwardDescription"),
            "effective_from": obj.get("effectiveFrom"),
            "effective_until": obj.get("effectiveUntil")
        })
        return _obj
