# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Union
from pydantic.v1 import BaseModel, Field, StrictBool, StrictFloat, StrictInt, constr
from lusid.models.resource_id import ResourceId

class ComplianceRuleResult(BaseModel):
    """
    ComplianceRuleResult
    """
    rule_id: constr(strict=True, min_length=1) = Field(..., alias="ruleId", description="The unique identifierof a compliance rule")
    rule_name: constr(strict=True, min_length=1) = Field(..., alias="ruleName", description="The User-given name of the rule")
    rule_description: constr(strict=True, min_length=1) = Field(..., alias="ruleDescription", description="The User-given description of the rule")
    portfolio: ResourceId = Field(...)
    passed: StrictBool = Field(..., description="The result of an individual compliance run, true if passed")
    result_value: Union[StrictFloat, StrictInt] = Field(..., alias="resultValue", description="The calculation result that was used to confirm a pass/fail")
    rule_information_match: constr(strict=True, min_length=1) = Field(..., alias="ruleInformationMatch", description="The value matched by the rule")
    rule_information_key: constr(strict=True, min_length=1) = Field(..., alias="ruleInformationKey", description="The property key matched by the rule")
    rule_lower_limit: Union[StrictFloat, StrictInt] = Field(..., alias="ruleLowerLimit", description="The lower limit of the rule")
    rule_upper_limit: Union[StrictFloat, StrictInt] = Field(..., alias="ruleUpperLimit", description="The upper limit of the rule")
    __properties = ["ruleId", "ruleName", "ruleDescription", "portfolio", "passed", "resultValue", "ruleInformationMatch", "ruleInformationKey", "ruleLowerLimit", "ruleUpperLimit"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ComplianceRuleResult:
        """Create an instance of ComplianceRuleResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of portfolio
        if self.portfolio:
            _dict['portfolio'] = self.portfolio.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ComplianceRuleResult:
        """Create an instance of ComplianceRuleResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ComplianceRuleResult.parse_obj(obj)

        _obj = ComplianceRuleResult.parse_obj({
            "rule_id": obj.get("ruleId"),
            "rule_name": obj.get("ruleName"),
            "rule_description": obj.get("ruleDescription"),
            "portfolio": ResourceId.from_dict(obj.get("portfolio")) if obj.get("portfolio") is not None else None,
            "passed": obj.get("passed"),
            "result_value": obj.get("resultValue"),
            "rule_information_match": obj.get("ruleInformationMatch"),
            "rule_information_key": obj.get("ruleInformationKey"),
            "rule_lower_limit": obj.get("ruleLowerLimit"),
            "rule_upper_limit": obj.get("ruleUpperLimit")
        })
        return _obj
