# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic.v1 import BaseModel, Field, StrictBool, constr, validator

class DateAttributes(BaseModel):
    """
    DateAttributes
    """
    irregular: StrictBool = Field(...)
    irregular_session: StrictBool = Field(..., alias="irregularSession")
    new_hours: StrictBool = Field(..., alias="newHours")
    activity: Optional[constr(strict=True, max_length=100, min_length=0)] = None
    first_open: Optional[constr(strict=True, max_length=100, min_length=0)] = Field(None, alias="firstOpen")
    last_open: Optional[constr(strict=True, max_length=100, min_length=0)] = Field(None, alias="lastOpen")
    first_close: Optional[constr(strict=True, max_length=100, min_length=0)] = Field(None, alias="firstClose")
    last_close: Optional[constr(strict=True, max_length=100, min_length=0)] = Field(None, alias="lastClose")
    __properties = ["irregular", "irregularSession", "newHours", "activity", "firstOpen", "lastOpen", "firstClose", "lastClose"]

    @validator('activity')
    def activity_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[a-zA-Z0-9\-_]+$", value):
            raise ValueError(r"must validate the regular expression /^[a-zA-Z0-9\-_]+$/")
        return value

    @validator('first_open')
    def first_open_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[a-zA-Z0-9\-_]+$", value):
            raise ValueError(r"must validate the regular expression /^[a-zA-Z0-9\-_]+$/")
        return value

    @validator('last_open')
    def last_open_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[a-zA-Z0-9\-_]+$", value):
            raise ValueError(r"must validate the regular expression /^[a-zA-Z0-9\-_]+$/")
        return value

    @validator('first_close')
    def first_close_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[a-zA-Z0-9\-_]+$", value):
            raise ValueError(r"must validate the regular expression /^[a-zA-Z0-9\-_]+$/")
        return value

    @validator('last_close')
    def last_close_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[a-zA-Z0-9\-_]+$", value):
            raise ValueError(r"must validate the regular expression /^[a-zA-Z0-9\-_]+$/")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> DateAttributes:
        """Create an instance of DateAttributes from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if activity (nullable) is None
        # and __fields_set__ contains the field
        if self.activity is None and "activity" in self.__fields_set__:
            _dict['activity'] = None

        # set to None if first_open (nullable) is None
        # and __fields_set__ contains the field
        if self.first_open is None and "first_open" in self.__fields_set__:
            _dict['firstOpen'] = None

        # set to None if last_open (nullable) is None
        # and __fields_set__ contains the field
        if self.last_open is None and "last_open" in self.__fields_set__:
            _dict['lastOpen'] = None

        # set to None if first_close (nullable) is None
        # and __fields_set__ contains the field
        if self.first_close is None and "first_close" in self.__fields_set__:
            _dict['firstClose'] = None

        # set to None if last_close (nullable) is None
        # and __fields_set__ contains the field
        if self.last_close is None and "last_close" in self.__fields_set__:
            _dict['lastClose'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> DateAttributes:
        """Create an instance of DateAttributes from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return DateAttributes.parse_obj(obj)

        _obj = DateAttributes.parse_obj({
            "irregular": obj.get("irregular"),
            "irregular_session": obj.get("irregularSession"),
            "new_hours": obj.get("newHours"),
            "activity": obj.get("activity"),
            "first_open": obj.get("firstOpen"),
            "last_open": obj.get("lastOpen"),
            "first_close": obj.get("firstClose"),
            "last_close": obj.get("lastClose")
        })
        return _obj
