# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, List, Optional, Union
from pydantic.v1 import BaseModel, Field, StrictFloat, StrictInt, conlist, constr, validator
from lusid.models.link import Link

class FeeAccrual(BaseModel):
    """
    FeeAccrual
    """
    effective_at: datetime = Field(..., alias="effectiveAt", description="The effective date for which the fee accrual has been calculated.")
    code: constr(strict=True, max_length=64, min_length=1) = Field(..., description="The code of the fee for which the accrual has been calculated.")
    name: constr(strict=True, max_length=50, min_length=0) = Field(..., description="The name of the fee for which the accrual has been calculated.")
    calculation_base: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="calculationBase", description="The result of the evaluating the fee's calculation base expression.")
    amount: Optional[Union[StrictFloat, StrictInt]] = Field(None, description="The result of applying the fee to the calculation base, and scaled down to a day.")
    previous_accrual: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="previousAccrual", description="The previous valuation point's total accrual.")
    previous_total_accrual: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="previousTotalAccrual", description="The previous valuation point's total accrual.")
    total_accrual: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="totalAccrual", description="The sum of the PreviousAccrual and Amount.")
    links: Optional[conlist(Link)] = None
    __properties = ["effectiveAt", "code", "name", "calculationBase", "amount", "previousAccrual", "previousTotalAccrual", "totalAccrual", "links"]

    @validator('code')
    def code_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[a-zA-Z0-9\-_]+$", value):
            raise ValueError(r"must validate the regular expression /^[a-zA-Z0-9\-_]+$/")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> FeeAccrual:
        """Create an instance of FeeAccrual from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        # set to None if links (nullable) is None
        # and __fields_set__ contains the field
        if self.links is None and "links" in self.__fields_set__:
            _dict['links'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> FeeAccrual:
        """Create an instance of FeeAccrual from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return FeeAccrual.parse_obj(obj)

        _obj = FeeAccrual.parse_obj({
            "effective_at": obj.get("effectiveAt"),
            "code": obj.get("code"),
            "name": obj.get("name"),
            "calculation_base": obj.get("calculationBase"),
            "amount": obj.get("amount"),
            "previous_accrual": obj.get("previousAccrual"),
            "previous_total_accrual": obj.get("previousTotalAccrual"),
            "total_accrual": obj.get("totalAccrual"),
            "links": [Link.from_dict(_item) for _item in obj.get("links")] if obj.get("links") is not None else None
        })
        return _obj
