# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional
from pydantic.v1 import BaseModel, Field, conlist, constr, validator
from lusid.models.general_ledger_profile_mapping import GeneralLedgerProfileMapping

class GeneralLedgerProfileRequest(BaseModel):
    """
    A General Ledger Profile Definition.  # noqa: E501
    """
    general_ledger_profile_code: constr(strict=True, max_length=64, min_length=1) = Field(..., alias="generalLedgerProfileCode", description="The unique code for the General Ledger Profile")
    display_name: constr(strict=True, max_length=512, min_length=1) = Field(..., alias="displayName", description="The name of the General Ledger Profile")
    description: Optional[constr(strict=True, max_length=1024, min_length=0)] = Field(None, description="A description for the General Ledger Profile")
    general_ledger_profile_mappings: conlist(GeneralLedgerProfileMapping, max_items=1000) = Field(..., alias="generalLedgerProfileMappings", description="Rules for mapping Account or property values to aggregation pattern definitions")
    __properties = ["generalLedgerProfileCode", "displayName", "description", "generalLedgerProfileMappings"]

    @validator('general_ledger_profile_code')
    def general_ledger_profile_code_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[a-zA-Z0-9\-_]+$", value):
            raise ValueError(r"must validate the regular expression /^[a-zA-Z0-9\-_]+$/")
        return value

    @validator('display_name')
    def display_name_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[\s\S]*$", value):
            raise ValueError(r"must validate the regular expression /^[\s\S]*$/")
        return value

    @validator('description')
    def description_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[\s\S]*$", value):
            raise ValueError(r"must validate the regular expression /^[\s\S]*$/")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> GeneralLedgerProfileRequest:
        """Create an instance of GeneralLedgerProfileRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in general_ledger_profile_mappings (list)
        _items = []
        if self.general_ledger_profile_mappings:
            for _item in self.general_ledger_profile_mappings:
                if _item:
                    _items.append(_item.to_dict())
            _dict['generalLedgerProfileMappings'] = _items
        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict['description'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> GeneralLedgerProfileRequest:
        """Create an instance of GeneralLedgerProfileRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return GeneralLedgerProfileRequest.parse_obj(obj)

        _obj = GeneralLedgerProfileRequest.parse_obj({
            "general_ledger_profile_code": obj.get("generalLedgerProfileCode"),
            "display_name": obj.get("displayName"),
            "description": obj.get("description"),
            "general_ledger_profile_mappings": [GeneralLedgerProfileMapping.from_dict(_item) for _item in obj.get("generalLedgerProfileMappings")] if obj.get("generalLedgerProfileMappings") is not None else None
        })
        return _obj
