# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, List, Optional
from pydantic.v1 import BaseModel, Field, StrictInt, StrictStr, conlist, validator
from lusid.models.link import Link
from lusid.models.reference_portfolio_constituent import ReferencePortfolioConstituent

class GetReferencePortfolioConstituentsResponse(BaseModel):
    """
    GetReferencePortfolioConstituentsResponse
    """
    effective_from: datetime = Field(..., alias="effectiveFrom")
    weight_type: StrictStr = Field(..., alias="weightType", description="The available values are: Static, Floating, Periodical")
    period_type: Optional[StrictStr] = Field(None, alias="periodType", description="The available values are: Daily, Weekly, Monthly, Quarterly, Annually")
    period_count: Optional[StrictInt] = Field(None, alias="periodCount")
    constituents: conlist(ReferencePortfolioConstituent) = Field(..., description="Set of constituents (instrument/weight pairings)")
    href: Optional[StrictStr] = Field(None, description="The Uri that returns the same result as the original request,  but may include resolved as at time(s).")
    links: Optional[conlist(Link)] = None
    __properties = ["effectiveFrom", "weightType", "periodType", "periodCount", "constituents", "href", "links"]

    @validator('weight_type')
    def weight_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('Static', 'Floating', 'Periodical'):
            raise ValueError("must be one of enum values ('Static', 'Floating', 'Periodical')")
        return value

    @validator('period_type')
    def period_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('Daily', 'Weekly', 'Monthly', 'Quarterly', 'Annually'):
            raise ValueError("must be one of enum values ('Daily', 'Weekly', 'Monthly', 'Quarterly', 'Annually')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> GetReferencePortfolioConstituentsResponse:
        """Create an instance of GetReferencePortfolioConstituentsResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in constituents (list)
        _items = []
        if self.constituents:
            for _item in self.constituents:
                if _item:
                    _items.append(_item.to_dict())
            _dict['constituents'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        # set to None if period_type (nullable) is None
        # and __fields_set__ contains the field
        if self.period_type is None and "period_type" in self.__fields_set__:
            _dict['periodType'] = None

        # set to None if period_count (nullable) is None
        # and __fields_set__ contains the field
        if self.period_count is None and "period_count" in self.__fields_set__:
            _dict['periodCount'] = None

        # set to None if href (nullable) is None
        # and __fields_set__ contains the field
        if self.href is None and "href" in self.__fields_set__:
            _dict['href'] = None

        # set to None if links (nullable) is None
        # and __fields_set__ contains the field
        if self.links is None and "links" in self.__fields_set__:
            _dict['links'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> GetReferencePortfolioConstituentsResponse:
        """Create an instance of GetReferencePortfolioConstituentsResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return GetReferencePortfolioConstituentsResponse.parse_obj(obj)

        _obj = GetReferencePortfolioConstituentsResponse.parse_obj({
            "effective_from": obj.get("effectiveFrom"),
            "weight_type": obj.get("weightType"),
            "period_type": obj.get("periodType"),
            "period_count": obj.get("periodCount"),
            "constituents": [ReferencePortfolioConstituent.from_dict(_item) for _item in obj.get("constituents")] if obj.get("constituents") is not None else None,
            "href": obj.get("href"),
            "links": [Link.from_dict(_item) for _item in obj.get("links")] if obj.get("links") is not None else None
        })
        return _obj
