# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict
from pydantic.v1 import BaseModel, Field, constr, validator

class IndustryClassifier(BaseModel):
    """
    Object describing a particular industry classifier,  which comprises a classification code and the name of the classification system to which the code belongs.  # noqa: E501
    """
    classification_system_name: constr(strict=True, min_length=1) = Field(..., alias="classificationSystemName", description="The name of the classification system to which the classification code belongs (e.g. GICS).")
    classification_code: constr(strict=True, max_length=64, min_length=1) = Field(..., alias="classificationCode", description="The specific industry classification code assigned to the legal entity.")
    __properties = ["classificationSystemName", "classificationCode"]

    @validator('classification_code')
    def classification_code_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[a-zA-Z0-9\-_]+$", value):
            raise ValueError(r"must validate the regular expression /^[a-zA-Z0-9\-_]+$/")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> IndustryClassifier:
        """Create an instance of IndustryClassifier from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> IndustryClassifier:
        """Create an instance of IndustryClassifier from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return IndustryClassifier.parse_obj(obj)

        _obj = IndustryClassifier.parse_obj({
            "classification_system_name": obj.get("classificationSystemName"),
            "classification_code": obj.get("classificationCode")
        })
        return _obj
