# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, List, Optional
from pydantic.v1 import BaseModel, Field, StrictInt, StrictStr, conlist
from lusid.models.link import Link
from lusid.models.resource_id import ResourceId
from lusid.models.version import Version

class InstrumentEventInstruction(BaseModel):
    """
    An instruction for an instrument event  # noqa: E501
    """
    instrument_event_instruction_id: Optional[StrictStr] = Field(None, alias="instrumentEventInstructionId", description="The unique identifier for this instruction")
    portfolio_id: Optional[ResourceId] = Field(None, alias="portfolioId")
    instrument_event_id: Optional[StrictStr] = Field(None, alias="instrumentEventId", description="The identifier of the instrument event being instructed")
    instruction_type: Optional[StrictStr] = Field(None, alias="instructionType", description="The type of instruction (Ignore, ElectForPortfolio, ElectForHolding)")
    election_key: Optional[StrictStr] = Field(None, alias="electionKey", description="For elected instructions, the key to be chosen")
    holding_id: Optional[StrictInt] = Field(None, alias="holdingId", description="For holding instructions, the id of the holding for which the instruction will apply")
    version: Optional[Version] = None
    href: Optional[StrictStr] = Field(None, description="The uri for this version of this instruction")
    entitlement_date_instructed: Optional[datetime] = Field(None, alias="entitlementDateInstructed", description="The instructed entitlement date for the event (where none is set on the event itself)")
    links: Optional[conlist(Link)] = None
    __properties = ["instrumentEventInstructionId", "portfolioId", "instrumentEventId", "instructionType", "electionKey", "holdingId", "version", "href", "entitlementDateInstructed", "links"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> InstrumentEventInstruction:
        """Create an instance of InstrumentEventInstruction from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of portfolio_id
        if self.portfolio_id:
            _dict['portfolioId'] = self.portfolio_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of version
        if self.version:
            _dict['version'] = self.version.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        # set to None if instrument_event_instruction_id (nullable) is None
        # and __fields_set__ contains the field
        if self.instrument_event_instruction_id is None and "instrument_event_instruction_id" in self.__fields_set__:
            _dict['instrumentEventInstructionId'] = None

        # set to None if instrument_event_id (nullable) is None
        # and __fields_set__ contains the field
        if self.instrument_event_id is None and "instrument_event_id" in self.__fields_set__:
            _dict['instrumentEventId'] = None

        # set to None if instruction_type (nullable) is None
        # and __fields_set__ contains the field
        if self.instruction_type is None and "instruction_type" in self.__fields_set__:
            _dict['instructionType'] = None

        # set to None if election_key (nullable) is None
        # and __fields_set__ contains the field
        if self.election_key is None and "election_key" in self.__fields_set__:
            _dict['electionKey'] = None

        # set to None if holding_id (nullable) is None
        # and __fields_set__ contains the field
        if self.holding_id is None and "holding_id" in self.__fields_set__:
            _dict['holdingId'] = None

        # set to None if href (nullable) is None
        # and __fields_set__ contains the field
        if self.href is None and "href" in self.__fields_set__:
            _dict['href'] = None

        # set to None if entitlement_date_instructed (nullable) is None
        # and __fields_set__ contains the field
        if self.entitlement_date_instructed is None and "entitlement_date_instructed" in self.__fields_set__:
            _dict['entitlementDateInstructed'] = None

        # set to None if links (nullable) is None
        # and __fields_set__ contains the field
        if self.links is None and "links" in self.__fields_set__:
            _dict['links'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> InstrumentEventInstruction:
        """Create an instance of InstrumentEventInstruction from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return InstrumentEventInstruction.parse_obj(obj)

        _obj = InstrumentEventInstruction.parse_obj({
            "instrument_event_instruction_id": obj.get("instrumentEventInstructionId"),
            "portfolio_id": ResourceId.from_dict(obj.get("portfolioId")) if obj.get("portfolioId") is not None else None,
            "instrument_event_id": obj.get("instrumentEventId"),
            "instruction_type": obj.get("instructionType"),
            "election_key": obj.get("electionKey"),
            "holding_id": obj.get("holdingId"),
            "version": Version.from_dict(obj.get("version")) if obj.get("version") is not None else None,
            "href": obj.get("href"),
            "entitlement_date_instructed": obj.get("entitlementDateInstructed"),
            "links": [Link.from_dict(_item) for _item in obj.get("links")] if obj.get("links") is not None else None
        })
        return _obj
