# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic.v1 import BaseModel, Field
from lusid.models.error_detail import ErrorDetail
from lusid.models.instrument_event_instruction import InstrumentEventInstruction

class InstrumentEventInstructionsResponse(BaseModel):
    """
    The collection of successfully upserted instructions, and the collection of failures for those instructions that could not be upserted  # noqa: E501
    """
    values: Optional[Dict[str, InstrumentEventInstruction]] = Field(None, description="The collection of successfully upserted instructions")
    failed: Optional[Dict[str, ErrorDetail]] = Field(None, description="The collection of error information for instructions that could not be upserted")
    __properties = ["values", "failed"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> InstrumentEventInstructionsResponse:
        """Create an instance of InstrumentEventInstructionsResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each value in values (dict)
        _field_dict = {}
        if self.values:
            for _key in self.values:
                if self.values[_key]:
                    _field_dict[_key] = self.values[_key].to_dict()
            _dict['values'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in failed (dict)
        _field_dict = {}
        if self.failed:
            for _key in self.failed:
                if self.failed[_key]:
                    _field_dict[_key] = self.failed[_key].to_dict()
            _dict['failed'] = _field_dict
        # set to None if values (nullable) is None
        # and __fields_set__ contains the field
        if self.values is None and "values" in self.__fields_set__:
            _dict['values'] = None

        # set to None if failed (nullable) is None
        # and __fields_set__ contains the field
        if self.failed is None and "failed" in self.__fields_set__:
            _dict['failed'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> InstrumentEventInstructionsResponse:
        """Create an instance of InstrumentEventInstructionsResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return InstrumentEventInstructionsResponse.parse_obj(obj)

        _obj = InstrumentEventInstructionsResponse.parse_obj({
            "values": dict(
                (_k, InstrumentEventInstruction.from_dict(_v))
                for _k, _v in obj.get("values").items()
            )
            if obj.get("values") is not None
            else None,
            "failed": dict(
                (_k, ErrorDetail.from_dict(_v))
                for _k, _v in obj.get("failed").items()
            )
            if obj.get("failed") is not None
            else None
        })
        return _obj
