# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, Optional
from pydantic.v1 import BaseModel, Field, constr

class InstrumentIdValue(BaseModel):
    """
    InstrumentIdValue
    """
    value: constr(strict=True, min_length=1) = Field(..., description="The value of the identifier.")
    effective_at: Optional[datetime] = Field(None, alias="effectiveAt", description="The effective datetime from which the identifier will be valid. If left unspecified the default value is the beginning of time.")
    __properties = ["value", "effectiveAt"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> InstrumentIdValue:
        """Create an instance of InstrumentIdValue from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> InstrumentIdValue:
        """Create an instance of InstrumentIdValue from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return InstrumentIdValue.parse_obj(obj)

        _obj = InstrumentIdValue.parse_obj({
            "value": obj.get("value"),
            "effective_at": obj.get("effectiveAt")
        })
        return _obj
