# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional
from pydantic.v1 import BaseModel, Field, conlist
from lusid.models.instrument_definition import InstrumentDefinition

class InstrumentMatch(BaseModel):
    """
    A collection of instrument search results  # noqa: E501
    """
    mastered_instruments: Optional[conlist(InstrumentDefinition)] = Field(None, alias="masteredInstruments", description="The collection of instruments found by the search which have been mastered within LUSID.")
    external_instruments: Optional[conlist(InstrumentDefinition)] = Field(None, alias="externalInstruments", description="The collection of instruments found by the search which have not been mastered within LUSID and instead found via OpenFIGI.")
    __properties = ["masteredInstruments", "externalInstruments"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> InstrumentMatch:
        """Create an instance of InstrumentMatch from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in mastered_instruments (list)
        _items = []
        if self.mastered_instruments:
            for _item in self.mastered_instruments:
                if _item:
                    _items.append(_item.to_dict())
            _dict['masteredInstruments'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in external_instruments (list)
        _items = []
        if self.external_instruments:
            for _item in self.external_instruments:
                if _item:
                    _items.append(_item.to_dict())
            _dict['externalInstruments'] = _items
        # set to None if mastered_instruments (nullable) is None
        # and __fields_set__ contains the field
        if self.mastered_instruments is None and "mastered_instruments" in self.__fields_set__:
            _dict['masteredInstruments'] = None

        # set to None if external_instruments (nullable) is None
        # and __fields_set__ contains the field
        if self.external_instruments is None and "external_instruments" in self.__fields_set__:
            _dict['externalInstruments'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> InstrumentMatch:
        """Create an instance of InstrumentMatch from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return InstrumentMatch.parse_obj(obj)

        _obj = InstrumentMatch.parse_obj({
            "mastered_instruments": [InstrumentDefinition.from_dict(_item) for _item in obj.get("masteredInstruments")] if obj.get("masteredInstruments") is not None else None,
            "external_instruments": [InstrumentDefinition.from_dict(_item) for _item in obj.get("externalInstruments")] if obj.get("externalInstruments") is not None else None
        })
        return _obj
