# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict
from pydantic.v1 import BaseModel, Field, StrictStr, validator

class ModelSelection(BaseModel):
    """
    The combination of a library to use and a model in that library that defines which pricing code will evaluate instruments  having a particular type/class. This allows us to control the model type and library for a given instrument.  # noqa: E501
    """
    library: StrictStr = Field(..., description="The available values are: Lusid, RefinitivQps, RefinitivTracsWeb, VolMaster, IsdaCds, YieldBook, LusidCalc")
    model: StrictStr = Field(..., description="The available values are: SimpleStatic, Discounting, VendorDefault, BlackScholes, ConstantTimeValueOfMoney, Bachelier, ForwardWithPoints, ForwardWithPointsUndiscounted, ForwardSpecifiedRate, ForwardSpecifiedRateUndiscounted, IndexNav, IndexPrice, InlinedIndex, ForwardFromCurve, ForwardFromCurveUndiscounted, BlackScholesDigital, BjerksundStensland1993, BondLookupPricer, FlexibleLoanPricer, CdsLookupPricer")
    __properties = ["library", "model"]

    @validator('library')
    def library_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('Lusid', 'RefinitivQps', 'RefinitivTracsWeb', 'VolMaster', 'IsdaCds', 'YieldBook', 'LusidCalc'):
            raise ValueError("must be one of enum values ('Lusid', 'RefinitivQps', 'RefinitivTracsWeb', 'VolMaster', 'IsdaCds', 'YieldBook', 'LusidCalc')")
        return value

    @validator('model')
    def model_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('SimpleStatic', 'Discounting', 'VendorDefault', 'BlackScholes', 'ConstantTimeValueOfMoney', 'Bachelier', 'ForwardWithPoints', 'ForwardWithPointsUndiscounted', 'ForwardSpecifiedRate', 'ForwardSpecifiedRateUndiscounted', 'IndexNav', 'IndexPrice', 'InlinedIndex', 'ForwardFromCurve', 'ForwardFromCurveUndiscounted', 'BlackScholesDigital', 'BjerksundStensland1993', 'BondLookupPricer', 'FlexibleLoanPricer', 'CdsLookupPricer'):
            raise ValueError("must be one of enum values ('SimpleStatic', 'Discounting', 'VendorDefault', 'BlackScholes', 'ConstantTimeValueOfMoney', 'Bachelier', 'ForwardWithPoints', 'ForwardWithPointsUndiscounted', 'ForwardSpecifiedRate', 'ForwardSpecifiedRateUndiscounted', 'IndexNav', 'IndexPrice', 'InlinedIndex', 'ForwardFromCurve', 'ForwardFromCurveUndiscounted', 'BlackScholesDigital', 'BjerksundStensland1993', 'BondLookupPricer', 'FlexibleLoanPricer', 'CdsLookupPricer')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ModelSelection:
        """Create an instance of ModelSelection from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ModelSelection:
        """Create an instance of ModelSelection from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ModelSelection.parse_obj(obj)

        _obj = ModelSelection.parse_obj({
            "library": obj.get("library"),
            "model": obj.get("model")
        })
        return _obj
