# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, Optional, Union
from pydantic.v1 import BaseModel, Field, StrictFloat, StrictInt

class OptionEntry(BaseModel):
    """
    Strike price against par and associated date for a bond call.  # noqa: E501
    """
    strike: Union[StrictFloat, StrictInt] = Field(..., description="The strike on this date")
    var_date: datetime = Field(..., alias="date", description="The date at which the option can be actioned at this strike")
    end_date: Optional[datetime] = Field(None, alias="endDate", description="If American exercise, this is the end of the exercise period.  Optional field. Defaults to the Date field if not set.")
    __properties = ["strike", "date", "endDate"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> OptionEntry:
        """Create an instance of OptionEntry from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if end_date (nullable) is None
        # and __fields_set__ contains the field
        if self.end_date is None and "end_date" in self.__fields_set__:
            _dict['endDate'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> OptionEntry:
        """Create an instance of OptionEntry from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return OptionEntry.parse_obj(obj)

        _obj = OptionEntry.parse_obj({
            "strike": obj.get("strike"),
            "var_date": obj.get("date"),
            "end_date": obj.get("endDate")
        })
        return _obj
