# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional, Union
from pydantic.v1 import BaseModel, Field, StrictFloat, StrictInt, StrictStr
from lusid.models.rounding_configuration import RoundingConfiguration

class OutputTransition(BaseModel):
    """
    A 'transition' within a corporate action, representing an output transition.  # noqa: E501
    """
    instrument_identifiers: Dict[str, StrictStr] = Field(..., alias="instrumentIdentifiers", description="Unique instrument identifiers")
    units_factor: Union[StrictFloat, StrictInt] = Field(..., alias="unitsFactor", description="The factor to scale units by")
    cost_factor: Union[StrictFloat, StrictInt] = Field(..., alias="costFactor", description="The factor to scale cost by")
    lusid_instrument_id: Optional[StrictStr] = Field(None, alias="lusidInstrumentId", description="LUSID's internal unique instrument identifier, resolved from the instrument identifiers")
    instrument_scope: Optional[StrictStr] = Field(None, alias="instrumentScope", description="The scope in which the instrument lies.")
    rounding: Optional[RoundingConfiguration] = None
    __properties = ["instrumentIdentifiers", "unitsFactor", "costFactor", "lusidInstrumentId", "instrumentScope", "rounding"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> OutputTransition:
        """Create an instance of OutputTransition from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "lusid_instrument_id",
                            "instrument_scope",
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of rounding
        if self.rounding:
            _dict['rounding'] = self.rounding.to_dict()
        # set to None if lusid_instrument_id (nullable) is None
        # and __fields_set__ contains the field
        if self.lusid_instrument_id is None and "lusid_instrument_id" in self.__fields_set__:
            _dict['lusidInstrumentId'] = None

        # set to None if instrument_scope (nullable) is None
        # and __fields_set__ contains the field
        if self.instrument_scope is None and "instrument_scope" in self.__fields_set__:
            _dict['instrumentScope'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> OutputTransition:
        """Create an instance of OutputTransition from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return OutputTransition.parse_obj(obj)

        _obj = OutputTransition.parse_obj({
            "instrument_identifiers": obj.get("instrumentIdentifiers"),
            "units_factor": obj.get("unitsFactor"),
            "cost_factor": obj.get("costFactor"),
            "lusid_instrument_id": obj.get("lusidInstrumentId"),
            "instrument_scope": obj.get("instrumentScope"),
            "rounding": RoundingConfiguration.from_dict(obj.get("rounding")) if obj.get("rounding") is not None else None
        })
        return _obj
