# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic.v1 import BaseModel, Field, StrictStr, validator

class PropertyFilter(BaseModel):
    """
    PropertyFilter
    """
    left: Optional[StrictStr] = Field(None, description="The key that uniquely identifies a queryable address in Lusid.")
    operator: Optional[StrictStr] = Field(None, description="The available values are: Equals, NotEquals, GreaterThan, GreaterThanOrEqualTo, LessThan, LessThanOrEqualTo, In")
    right: Optional[Any] = None
    right_operand_type: Optional[StrictStr] = Field(None, alias="rightOperandType", description="The available values are: Absolute, Property")
    __properties = ["left", "operator", "right", "rightOperandType"]

    @validator('operator')
    def operator_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('Equals', 'NotEquals', 'GreaterThan', 'GreaterThanOrEqualTo', 'LessThan', 'LessThanOrEqualTo', 'In'):
            raise ValueError("must be one of enum values ('Equals', 'NotEquals', 'GreaterThan', 'GreaterThanOrEqualTo', 'LessThan', 'LessThanOrEqualTo', 'In')")
        return value

    @validator('right_operand_type')
    def right_operand_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('Absolute', 'Property'):
            raise ValueError("must be one of enum values ('Absolute', 'Property')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PropertyFilter:
        """Create an instance of PropertyFilter from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if left (nullable) is None
        # and __fields_set__ contains the field
        if self.left is None and "left" in self.__fields_set__:
            _dict['left'] = None

        # set to None if right (nullable) is None
        # and __fields_set__ contains the field
        if self.right is None and "right" in self.__fields_set__:
            _dict['right'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PropertyFilter:
        """Create an instance of PropertyFilter from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return PropertyFilter.parse_obj(obj)

        _obj = PropertyFilter.parse_obj({
            "left": obj.get("left"),
            "operator": obj.get("operator"),
            "right": obj.get("right"),
            "right_operand_type": obj.get("rightOperandType")
        })
        return _obj
