# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional
from pydantic.v1 import BaseModel, Field, conlist, constr, validator
from lusid.models.recipe_block import RecipeBlock

class RecipeComposer(BaseModel):
    """
    Recipe composer is an object used to dynamically compose Configuration Recipe from atomic operations.  # noqa: E501
    """
    scope: constr(strict=True, max_length=64, min_length=1) = Field(..., description="The scope used when updating or inserting the Recipe Composer.")
    code: constr(strict=True, max_length=64, min_length=1) = Field(..., description="User given string name (code) to identify the recipe.")
    operations: Optional[conlist(RecipeBlock)] = Field(None, description="Atomic operations used to compose a Configuration Recipe.")
    __properties = ["scope", "code", "operations"]

    @validator('scope')
    def scope_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[a-zA-Z0-9\-_]+$", value):
            raise ValueError(r"must validate the regular expression /^[a-zA-Z0-9\-_]+$/")
        return value

    @validator('code')
    def code_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[a-zA-Z0-9\-_]+$", value):
            raise ValueError(r"must validate the regular expression /^[a-zA-Z0-9\-_]+$/")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> RecipeComposer:
        """Create an instance of RecipeComposer from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in operations (list)
        _items = []
        if self.operations:
            for _item in self.operations:
                if _item:
                    _items.append(_item.to_dict())
            _dict['operations'] = _items
        # set to None if operations (nullable) is None
        # and __fields_set__ contains the field
        if self.operations is None and "operations" in self.__fields_set__:
            _dict['operations'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> RecipeComposer:
        """Create an instance of RecipeComposer from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return RecipeComposer.parse_obj(obj)

        _obj = RecipeComposer.parse_obj({
            "scope": obj.get("scope"),
            "code": obj.get("code"),
            "operations": [RecipeBlock.from_dict(_item) for _item in obj.get("operations")] if obj.get("operations") is not None else None
        })
        return _obj
