# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional
from pydantic.v1 import BaseModel, Field, StrictStr, conlist
from lusid.models.reconciliation_left_right_address_key_pair import ReconciliationLeftRightAddressKeyPair
from lusid.models.reconciliation_rule import ReconciliationRule
from lusid.models.valuation_request import ValuationRequest

class ReconciliationRequest(BaseModel):
    """
    Specification for the reconciliation request. Left and Right hand sides are constructed. Each consists of a valuation of a portfolio  using an aggregation request. The results of this can then be compared to each other. The difference, which is effectively a risk based  difference allows comparison of the effects of changing a recipe, valuation date, or (though it may or may not make logical sense) a portfolio.  For instance, one might look at the difference in risk caused by the addition of transaction to a portfolio, or through changing the valuation  methodology or system.  # noqa: E501
    """
    left: ValuationRequest = Field(...)
    right: ValuationRequest = Field(...)
    left_to_right_mapping: Optional[conlist(ReconciliationLeftRightAddressKeyPair)] = Field(None, alias="leftToRightMapping", description="The mapping from property keys requested by left aggregation to property keys on right hand side")
    comparison_rules: Optional[conlist(ReconciliationRule)] = Field(None, alias="comparisonRules", description="The set of rules to be used in comparing values. These are the rules that determine what constitues a match.  The simplest is obviously an exact one-for-one comparison, but tolerances on numerical or date time values and  case-insensitive string comparison are supported amongst other types.")
    preserve_keys: Optional[conlist(StrictStr)] = Field(None, alias="preserveKeys", description="List of keys to preserve (from rhs) in the diff. Used in conjunction with filtering/grouping.  If two values are equal, for a given key then the value is elided from the results. Setting it here  will preserve it (takes the values from the RHS and puts it into the line by line results).")
    __properties = ["left", "right", "leftToRightMapping", "comparisonRules", "preserveKeys"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ReconciliationRequest:
        """Create an instance of ReconciliationRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of left
        if self.left:
            _dict['left'] = self.left.to_dict()
        # override the default output from pydantic by calling `to_dict()` of right
        if self.right:
            _dict['right'] = self.right.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in left_to_right_mapping (list)
        _items = []
        if self.left_to_right_mapping:
            for _item in self.left_to_right_mapping:
                if _item:
                    _items.append(_item.to_dict())
            _dict['leftToRightMapping'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in comparison_rules (list)
        _items = []
        if self.comparison_rules:
            for _item in self.comparison_rules:
                if _item:
                    _items.append(_item.to_dict())
            _dict['comparisonRules'] = _items
        # set to None if left_to_right_mapping (nullable) is None
        # and __fields_set__ contains the field
        if self.left_to_right_mapping is None and "left_to_right_mapping" in self.__fields_set__:
            _dict['leftToRightMapping'] = None

        # set to None if comparison_rules (nullable) is None
        # and __fields_set__ contains the field
        if self.comparison_rules is None and "comparison_rules" in self.__fields_set__:
            _dict['comparisonRules'] = None

        # set to None if preserve_keys (nullable) is None
        # and __fields_set__ contains the field
        if self.preserve_keys is None and "preserve_keys" in self.__fields_set__:
            _dict['preserveKeys'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ReconciliationRequest:
        """Create an instance of ReconciliationRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ReconciliationRequest.parse_obj(obj)

        _obj = ReconciliationRequest.parse_obj({
            "left": ValuationRequest.from_dict(obj.get("left")) if obj.get("left") is not None else None,
            "right": ValuationRequest.from_dict(obj.get("right")) if obj.get("right") is not None else None,
            "left_to_right_mapping": [ReconciliationLeftRightAddressKeyPair.from_dict(_item) for _item in obj.get("leftToRightMapping")] if obj.get("leftToRightMapping") is not None else None,
            "comparison_rules": [ReconciliationRule.from_dict(_item) for _item in obj.get("comparisonRules")] if obj.get("comparisonRules") is not None else None,
            "preserve_keys": obj.get("preserveKeys")
        })
        return _obj
