# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional, Union
from pydantic.v1 import BaseModel, Field, StrictBool, StrictFloat, StrictInt, constr
from lusid.models.units_ratio import UnitsRatio

class SecurityElection(BaseModel):
    """
    Security election for Events that result in equity  # noqa: E501
    """
    election_key: constr(strict=True, min_length=1) = Field(..., alias="electionKey", description="Unique key associated to this election.")
    is_chosen: Optional[StrictBool] = Field(None, alias="isChosen", description="Is this the election that has been explicitly chosen from multiple options.")
    is_default: Optional[StrictBool] = Field(None, alias="isDefault", description="Is this election automatically applied in the absence of an election having been made.  May only be true for one election if multiple are provided.")
    price: Optional[Union[StrictFloat, StrictInt]] = Field(None, description="Price per unit of the security. At least one of UnitsRatio or Price must be provided.  Price must non-zero.")
    units_ratio: Optional[UnitsRatio] = Field(None, alias="unitsRatio")
    __properties = ["electionKey", "isChosen", "isDefault", "price", "unitsRatio"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SecurityElection:
        """Create an instance of SecurityElection from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of units_ratio
        if self.units_ratio:
            _dict['unitsRatio'] = self.units_ratio.to_dict()
        # set to None if price (nullable) is None
        # and __fields_set__ contains the field
        if self.price is None and "price" in self.__fields_set__:
            _dict['price'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SecurityElection:
        """Create an instance of SecurityElection from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SecurityElection.parse_obj(obj)

        _obj = SecurityElection.parse_obj({
            "election_key": obj.get("electionKey"),
            "is_chosen": obj.get("isChosen"),
            "is_default": obj.get("isDefault"),
            "price": obj.get("price"),
            "units_ratio": UnitsRatio.from_dict(obj.get("unitsRatio")) if obj.get("unitsRatio") is not None else None
        })
        return _obj
