# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, Optional, Union
from pydantic.v1 import BaseModel, Field, StrictFloat, StrictInt, StrictStr

class SettlementSchedule(BaseModel):
    """
    SettlementSchedule
    """
    trade_id: Optional[StrictStr] = Field(None, alias="tradeId")
    settlement_date: Optional[datetime] = Field(None, alias="settlementDate")
    units: Optional[Union[StrictFloat, StrictInt]] = None
    __properties = ["tradeId", "settlementDate", "units"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SettlementSchedule:
        """Create an instance of SettlementSchedule from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if trade_id (nullable) is None
        # and __fields_set__ contains the field
        if self.trade_id is None and "trade_id" in self.__fields_set__:
            _dict['tradeId'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SettlementSchedule:
        """Create an instance of SettlementSchedule from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SettlementSchedule.parse_obj(obj)

        _obj = SettlementSchedule.parse_obj({
            "trade_id": obj.get("tradeId"),
            "settlement_date": obj.get("settlementDate"),
            "units": obj.get("units")
        })
        return _obj
