# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional
from pydantic.v1 import BaseModel, Field, StrictInt, StrictStr, conlist

class StagedModificationsInfo(BaseModel):
    """
    The staged modifications metadata.  # noqa: E501
    """
    count_pending: StrictInt = Field(..., alias="countPending", description="The number of staged modifications for the entity with a status of Pending for the requested asAt.")
    href_pending: StrictStr = Field(..., alias="hrefPending", description="Link to the list staged modifications endpoint, filtered by entityType, entityUniqueId and status (= Pending).")
    ids_previewed: Optional[conlist(StrictStr)] = Field(None, alias="idsPreviewed", description="An array of the ids of any StagedModifications being previewed.")
    __properties = ["countPending", "hrefPending", "idsPreviewed"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> StagedModificationsInfo:
        """Create an instance of StagedModificationsInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if ids_previewed (nullable) is None
        # and __fields_set__ contains the field
        if self.ids_previewed is None and "ids_previewed" in self.__fields_set__:
            _dict['idsPreviewed'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> StagedModificationsInfo:
        """Create an instance of StagedModificationsInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return StagedModificationsInfo.parse_obj(obj)

        _obj = StagedModificationsInfo.parse_obj({
            "count_pending": obj.get("countPending"),
            "href_pending": obj.get("hrefPending"),
            "ids_previewed": obj.get("idsPreviewed")
        })
        return _obj
