# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional, Union
from pydantic.v1 import BaseModel, Field, StrictFloat, StrictInt, StrictStr, validator

class TransactionPrice(BaseModel):
    """
    TransactionPrice
    """
    price: Optional[Union[StrictFloat, StrictInt]] = None
    type: Optional[StrictStr] = Field(None, description="The available values are: Price, Yield, Spread, CashFlowPerUnit, CleanPrice, DirtyPrice")
    __properties = ["price", "type"]

    @validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('Price', 'Yield', 'Spread', 'CashFlowPerUnit', 'CleanPrice', 'DirtyPrice'):
            raise ValueError("must be one of enum values ('Price', 'Yield', 'Spread', 'CashFlowPerUnit', 'CleanPrice', 'DirtyPrice')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TransactionPrice:
        """Create an instance of TransactionPrice from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TransactionPrice:
        """Create an instance of TransactionPrice from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TransactionPrice.parse_obj(obj)

        _obj = TransactionPrice.parse_obj({
            "price": obj.get("price"),
            "type": obj.get("type")
        })
        return _obj
