# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List
from pydantic.v1 import BaseModel, Field, StrictStr, conlist, constr
from lusid.models.election_specification import ElectionSpecification
from lusid.models.eligibility_calculation import EligibilityCalculation
from lusid.models.template_field import TemplateField

class TransactionTemplateSpecification(BaseModel):
    """
    TransactionTemplateSpecification
    """
    instrument_event_type: constr(strict=True, min_length=1) = Field(..., alias="instrumentEventType")
    supported_instrument_types: conlist(StrictStr) = Field(..., alias="supportedInstrumentTypes")
    supported_participation_types: conlist(StrictStr) = Field(..., alias="supportedParticipationTypes")
    supported_election_types: conlist(ElectionSpecification) = Field(..., alias="supportedElectionTypes")
    supported_template_fields: conlist(TemplateField) = Field(..., alias="supportedTemplateFields")
    eligibility_calculation: EligibilityCalculation = Field(..., alias="eligibilityCalculation")
    __properties = ["instrumentEventType", "supportedInstrumentTypes", "supportedParticipationTypes", "supportedElectionTypes", "supportedTemplateFields", "eligibilityCalculation"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TransactionTemplateSpecification:
        """Create an instance of TransactionTemplateSpecification from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in supported_election_types (list)
        _items = []
        if self.supported_election_types:
            for _item in self.supported_election_types:
                if _item:
                    _items.append(_item.to_dict())
            _dict['supportedElectionTypes'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in supported_template_fields (list)
        _items = []
        if self.supported_template_fields:
            for _item in self.supported_template_fields:
                if _item:
                    _items.append(_item.to_dict())
            _dict['supportedTemplateFields'] = _items
        # override the default output from pydantic by calling `to_dict()` of eligibility_calculation
        if self.eligibility_calculation:
            _dict['eligibilityCalculation'] = self.eligibility_calculation.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TransactionTemplateSpecification:
        """Create an instance of TransactionTemplateSpecification from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TransactionTemplateSpecification.parse_obj(obj)

        _obj = TransactionTemplateSpecification.parse_obj({
            "instrument_event_type": obj.get("instrumentEventType"),
            "supported_instrument_types": obj.get("supportedInstrumentTypes"),
            "supported_participation_types": obj.get("supportedParticipationTypes"),
            "supported_election_types": [ElectionSpecification.from_dict(_item) for _item in obj.get("supportedElectionTypes")] if obj.get("supportedElectionTypes") is not None else None,
            "supported_template_fields": [TemplateField.from_dict(_item) for _item in obj.get("supportedTemplateFields")] if obj.get("supportedTemplateFields") is not None else None,
            "eligibility_calculation": EligibilityCalculation.from_dict(obj.get("eligibilityCalculation")) if obj.get("eligibilityCalculation") is not None else None
        })
        return _obj
