# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic.v1 import BaseModel, Field, constr
from lusid.models.dialect_schema import DialectSchema
from lusid.models.translation_input import TranslationInput

class TranslateEntitiesInlinedRequest(BaseModel):
    """
    Request to translate financial entities with a given script body.  The output of the translation is validated against a schema specified in the request.  # noqa: E501
    """
    entity_payloads: Dict[str, TranslationInput] = Field(..., alias="entityPayloads", description="Entity payloads to be translated indexed by (ephemeral) unique correlation ids.")
    script_body: constr(strict=True, max_length=500000, min_length=0) = Field(..., alias="scriptBody", description="The body of the translation script to use for translating the entities.")
    var_schema: Optional[DialectSchema] = Field(None, alias="schema")
    __properties = ["entityPayloads", "scriptBody", "schema"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TranslateEntitiesInlinedRequest:
        """Create an instance of TranslateEntitiesInlinedRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each value in entity_payloads (dict)
        _field_dict = {}
        if self.entity_payloads:
            for _key in self.entity_payloads:
                if self.entity_payloads[_key]:
                    _field_dict[_key] = self.entity_payloads[_key].to_dict()
            _dict['entityPayloads'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of var_schema
        if self.var_schema:
            _dict['schema'] = self.var_schema.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TranslateEntitiesInlinedRequest:
        """Create an instance of TranslateEntitiesInlinedRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TranslateEntitiesInlinedRequest.parse_obj(obj)

        _obj = TranslateEntitiesInlinedRequest.parse_obj({
            "entity_payloads": dict(
                (_k, TranslationInput.from_dict(_v))
                for _k, _v in obj.get("entityPayloads").items()
            )
            if obj.get("entityPayloads") is not None
            else None,
            "script_body": obj.get("scriptBody"),
            "var_schema": DialectSchema.from_dict(obj.get("schema")) if obj.get("schema") is not None else None
        })
        return _obj
