# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional, Union
from pydantic.v1 import BaseModel, Field, StrictFloat, StrictInt, StrictStr, conlist, constr
from lusid.models.fee_accrual import FeeAccrual
from lusid.models.fund_details import FundDetails
from lusid.models.fund_valuation_point_data import FundValuationPointData
from lusid.models.link import Link
from lusid.models.share_class_data import ShareClassData

class ValuationPointDataResponse(BaseModel):
    """
    The Valuation Point Data Response for the Fund and specified date.  # noqa: E501
    """
    href: Optional[StrictStr] = Field(None, description="The specific Uniform Resource Identifier (URI) for this resource at the requested effective and asAt datetime.")
    type: constr(strict=True, min_length=1) = Field(..., description="The Type of the associated Diary Entry ('PeriodBoundary','ValuationPoint','Other' or 'Adhoc' when a diary entry wasn't used).")
    status: constr(strict=True, min_length=1) = Field(..., description="The status of a Diary Entry of Type 'ValuationPoint'. Defaults to 'Estimate' when upserting a diary entry, moves to 'Candidate' or 'Final' when a ValuationPoint is accepted, and 'Final' when it is finalised. The status of a Diary Entry becomes 'Unofficial' when a diary entry wasn't used.")
    backout: Dict[str, Union[StrictFloat, StrictInt]] = Field(..., description="DEPRECATED. Bucket of detail for the Valuation Point, where data points have been 'backed out'.")
    dealing: Dict[str, Union[StrictFloat, StrictInt]] = Field(..., description="DEPRECATED. Bucket of detail for any 'Dealing' that has occured inside the queried period.")
    pn_l: Dict[str, Union[StrictFloat, StrictInt]] = Field(..., alias="pnL", description="DEPRECATED. Bucket of detail for 'PnL' that has occured inside the queried period.")
    gav: Union[StrictFloat, StrictInt] = Field(..., description="DEPRECATED. The Gross Asset Value of the Fund at the Period end. This is effectively a summation of all Trial balance entries linked to accounts of types 'Asset' and 'Liabilities'.")
    fees: Dict[str, FeeAccrual] = Field(..., description="DEPRECATED. Bucket of detail for any 'Fees' that have been charged in the selected period.")
    nav: Union[StrictFloat, StrictInt] = Field(..., description="DEPRECATED. The Net Asset Value of the Fund at the Period end. This represents the GAV with any fees applied in the period.")
    previous_nav: Union[StrictFloat, StrictInt] = Field(..., alias="previousNav", description="DEPRECATED. The Net Asset Value of the Fund at the End of the last Period.")
    fund_details: FundDetails = Field(..., alias="fundDetails")
    fund_valuation_point_data: FundValuationPointData = Field(..., alias="fundValuationPointData")
    share_class_data: conlist(ShareClassData) = Field(..., alias="shareClassData", description="The data for all share classes in fund. Share classes are identified by their short codes.")
    valuation_point_code: Optional[StrictStr] = Field(None, alias="valuationPointCode", description="The code of the valuation point.")
    previous_valuation_point_code: Optional[StrictStr] = Field(None, alias="previousValuationPointCode", description="The code of the previous valuation point.")
    links: Optional[conlist(Link)] = None
    __properties = ["href", "type", "status", "backout", "dealing", "pnL", "gav", "fees", "nav", "previousNav", "fundDetails", "fundValuationPointData", "shareClassData", "valuationPointCode", "previousValuationPointCode", "links"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ValuationPointDataResponse:
        """Create an instance of ValuationPointDataResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each value in fees (dict)
        _field_dict = {}
        if self.fees:
            for _key in self.fees:
                if self.fees[_key]:
                    _field_dict[_key] = self.fees[_key].to_dict()
            _dict['fees'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of fund_details
        if self.fund_details:
            _dict['fundDetails'] = self.fund_details.to_dict()
        # override the default output from pydantic by calling `to_dict()` of fund_valuation_point_data
        if self.fund_valuation_point_data:
            _dict['fundValuationPointData'] = self.fund_valuation_point_data.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in share_class_data (list)
        _items = []
        if self.share_class_data:
            for _item in self.share_class_data:
                if _item:
                    _items.append(_item.to_dict())
            _dict['shareClassData'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        # set to None if href (nullable) is None
        # and __fields_set__ contains the field
        if self.href is None and "href" in self.__fields_set__:
            _dict['href'] = None

        # set to None if valuation_point_code (nullable) is None
        # and __fields_set__ contains the field
        if self.valuation_point_code is None and "valuation_point_code" in self.__fields_set__:
            _dict['valuationPointCode'] = None

        # set to None if previous_valuation_point_code (nullable) is None
        # and __fields_set__ contains the field
        if self.previous_valuation_point_code is None and "previous_valuation_point_code" in self.__fields_set__:
            _dict['previousValuationPointCode'] = None

        # set to None if links (nullable) is None
        # and __fields_set__ contains the field
        if self.links is None and "links" in self.__fields_set__:
            _dict['links'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ValuationPointDataResponse:
        """Create an instance of ValuationPointDataResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ValuationPointDataResponse.parse_obj(obj)

        _obj = ValuationPointDataResponse.parse_obj({
            "href": obj.get("href"),
            "type": obj.get("type"),
            "status": obj.get("status"),
            "backout": obj.get("backout"),
            "dealing": obj.get("dealing"),
            "pn_l": obj.get("pnL"),
            "gav": obj.get("gav"),
            "fees": dict(
                (_k, FeeAccrual.from_dict(_v))
                for _k, _v in obj.get("fees").items()
            )
            if obj.get("fees") is not None
            else None,
            "nav": obj.get("nav"),
            "previous_nav": obj.get("previousNav"),
            "fund_details": FundDetails.from_dict(obj.get("fundDetails")) if obj.get("fundDetails") is not None else None,
            "fund_valuation_point_data": FundValuationPointData.from_dict(obj.get("fundValuationPointData")) if obj.get("fundValuationPointData") is not None else None,
            "share_class_data": [ShareClassData.from_dict(_item) for _item in obj.get("shareClassData")] if obj.get("shareClassData") is not None else None,
            "valuation_point_code": obj.get("valuationPointCode"),
            "previous_valuation_point_code": obj.get("previousValuationPointCode"),
            "links": [Link.from_dict(_item) for _item in obj.get("links")] if obj.get("links") is not None else None
        })
        return _obj
