# ─────────────────────────────────────────────────────
#                     PLAYGROUND
#   This file is just an experimental sandbox and is
#   not part of the implementation.
#
#   To run this code, execute python -m pepsi.
# ──────────────────────────────────────────────────────

# import pandas as pd
# from pepsi import Calculator

# # Calculator.hello_pepsi()

# from pepsi.analysis import _mann_whitney_u_test

# data = pd.read_csv("data/peptides.csv").dropna(subset=["Intensity"])
# data = data[data["PEP"] <= 0.01]

# metadata = pd.read_csv("data/metadata.csv")
# calc = Calculator(
#     dataset=data,
#     metadata=metadata,
# )
# features = calc.get_features()
# current_features = pd.merge(
#     features, metadata, on="Sample", how="left"
# )
# print(current_features.head())

# res = _mann_whitney_u_test(
#     df=current_features,
#     feature="GRAVY",
#     group_by="Group",
#     group_a="Type 1 diabetes",
#     group_b="Healthy control",
#     alternative="two-sided",
# )

from pepsi import Calculator
import plotly.graph_objects as go

calc = Calculator(
    seq="SVIDQSRVLNLGPITR",
    plot_params={
       "aa_distribution": True,
        "aa_distribution_order_by": "frequency",
        "aa_distribution_show_all": False,
        "classification": True,
        "classification_classify_by": "chemical",
    },
)
print(calc.plot_params)
plots = calc.get_plots()
i = 1
for plot in plots:
    plot.write_image(f"results/plot{i}.pdf")    
    i += 1