def 查询_取所有表名(连接对象):
    """
    查询并返回当前数据库中的所有表名。

    参数：
        - 连接对象：已连接到MySQL数据库的连接对象。

    返回值：
        - 表名列表：包含所有表名的列表。如果查询失败，则返回 None。

    使用示例（可以复制并直接修改）：
        表名列表 = zfx_mysql.查询_取所有表名(连接对象)

        # 替换参数：
        # - 连接对象：已建立的数据库连接对象

        # 使用返回的表名列表：
        # if 表名列表 is not None:
        #     print("所有表名:", 表名列表)
        # else:
        #     print("查询失败")
    """
    游标对象 = None
    try:
        # 创建游标对象
        游标对象 = 连接对象.cursor()

        # 执行查询来获取所有表名
        游标对象.execute("SHOW TABLES")

        # 获取查询结果，返回所有表名
        表名列表 = [表[0] for 表 in 游标对象.fetchall()]

        return 表名列表
    except Exception:
        # 如果出现异常，返回 None
        return None
    finally:
        # 无论是否发生异常，都关闭游标对象以释放资源
        if 游标对象:
            游标对象.close()