def 页面_等待元素子项数量(页面, 容器选择器: str, 子项选择器: str, 最小数量: int,
                     超时毫秒: int = 30000, 轮询间隔秒: float = 0.2):
    """
    功能：
        轮询检查某容器下子项元素的数量，直到达到“最小数量”或超时。
        适合数据列表/瀑布流/搜索结果等需要“足量渲染”后再解析的场景。

    参数：
        - 页面：Playwright 页面对象（sync）。
        - 容器选择器：字符串，父容器 CSS 选择器（例如商品网格容器）。
        - 子项选择器：字符串，子项 CSS 选择器（例如 "li" 或 ".card"）。
        - 最小数量：整数，期望的最少子项数量（达到即返回 True）。
        - 超时毫秒：整数，最大等待时长（默认 30000 毫秒）。
        - 轮询间隔秒：浮点数，每次检查之间的间隔（默认 0.2 秒）。

    返回值：
        - True  ：在超时时间内，子项数量达到或超过最小数量
        - False ：超时未达标（会打印当前统计数量），或发生异常

    注意：
        1) 建议先调用“页面_等待元素渲染完毕(容器, visible)”确保容器已可见，再等待数量。
        2) 若页面按分页/滚动动态加载，需配合滚动/点击“加载更多”后再次调用本函数。
        3) 选择器会拼接为 f"{容器选择器} {子项选择器}" 进行统计，请确保层级关系正确。

    使用示例：
        # 期望容器中至少出现 20 个 li
        页面_等待元素渲染完毕(页面, ".SearchProductGrid-module__container___jew-i")
        页面_等待元素子项数量(页面,
                        容器选择器=".SearchProductGrid-module__container___jew-i",
                        子项选择器="li",
                        最小数量=20,
                        超时毫秒=15000)
    """
    import time
    deadline = time.time() + 超时毫秒 / 1000.0
    当前数量 = 0
    选择器 = f"{容器选择器} {子项选择器}".strip()
    try:
        while time.time() < deadline:
            try:
                当前数量 = len(页面.query_selector_all(选择器))
                if 当前数量 >= 最小数量:
                    return True
            except Exception:
                # 忽略本次轮询异常，继续重试
                pass
            time.sleep(轮询间隔秒)
        print(f"等待子项数量超时：容器={容器选择器}，子项={子项选择器}，期望≥{最小数量}，实际={当前数量}")
        return False
    except Exception as e:
        print(f"等待子项数量失败：容器={容器选择器}，子项={子项选择器}，错误：{e}")
        return False