def 分割为固定大小(列表对象, 每组大小, debug=True):
    r"""
    将列表按固定大小进行分割，返回一个包含子列表的新列表。

    参数：
        - 列表对象 (list): 要处理的列表，例如 [1, 2, 3, 4, 5, 6]。
        - 每组大小 (int): 每个子列表的元素数量，例如 2。
        - debug (bool): 是否输出调试日志（异常时打印错误信息），默认值为 True。

    返回值：
        - list:
            - 成功时返回按固定大小分割后的列表（包含多个子列表）；
            - 如果输入为空列表或发生异常，返回空列表 []。

    注意事项：
        1. 输入必须是列表类型，否则会触发异常。
        2. 每组大小必须为大于0的正整数。
        3. 最后一个子列表元素数量可能小于指定大小。

    使用示例：
        新列表 = 分割为固定大小([1, 2, 3, 4, 5, 6], 2)
        新列表 = 分割为固定大小(["a", "b", "c", "d"], 3)
    """
    try:
        # 确保输入是列表类型
        if not isinstance(列表对象, list):
            raise TypeError("参数必须为列表类型")

        # 确保每组大小为正整数
        if not isinstance(每组大小, int) or 每组大小 <= 0:
            raise ValueError("每组大小必须为正整数")

        # 执行分组操作
        return [列表对象[i:i + 每组大小] for i in range(0, len(列表对象), 每组大小)]

    except Exception as e:
        if debug:
            print(f"[分割为固定大小] 功能异常：{e}（输入={列表对象}, 每组大小={每组大小}）")
        return []
