def 取左边(被查找的文本, 欲寻找的文本, 起始寻找位置=1, 是否不区分大小写=False):
    """
    从被查找的文本中寻找指定的文本，并返回该文本左边的所有字符。如果找不到，返回空字符串。

    参数:
        - 被查找的文本 (str): 要在其中进行查找的文本。
        - 欲寻找的文本 (str): 需要寻找的目标文本。
        - 起始寻找位置 (int, optional): 开始查找的位置索引，默认为 1。正数表示从左往右查找，负数表示从右往左查找。
        - 是否不区分大小写 (bool, optional): 如果为 True，查找时不区分大小写；如果为 False，区分大小写。默认值为 False。

    返回:
        - str: 欲寻找的文本左边的文本内容。如果找不到或出现异常，返回空字符串。

    示例用法:
        文本 = "这是一个示例文本，包含要寻找的文本"
        欲寻找的文本 = "示例"
        左边文本 = zfx_textutils.取左边(文本, 欲寻找的文本)
        print("欲寻找文本左边的内容:", 左边文本)
    """
    try:
        if 是否不区分大小写:
            被查找的文本 = 被查找的文本.lower()
            欲寻找的文本 = 欲寻找的文本.lower()

        if 起始寻找位置 < 0:
            被查找的文本 = 被查找的文本[::-1]
            欲寻找的文本 = 欲寻找的文本[::-1]

        index = 被查找的文本.find(欲寻找的文本, abs(起始寻找位置) - 1)
        if index != -1:
            if 起始寻找位置 < 0:
                return 被查找的文本[:index][::-1]
            else:
                return 被查找的文本[:index]
        else:
            return ""
    except Exception:
        return ""