def 取关键词出现次数(文件路径, 关键词):
    """
    从指定文本文件中获取特定关键词的出现次数。文件编码格式必须为 UTF-8，否则可能导致读取错误。

    参数:
        - 文件路径 (str): 要读取的文本文件路径，要求为 UTF-8 编码格式。
        - 关键词 (str): 要查找并计数出现次数的关键词。

    返回值:
        - int: 关键词在文件中出现的总次数。如果文件无法打开或处理出现错误，则返回 None。

    示例:
        次数 = 取关键词出现次数('example.txt', '关键词')
        if 次数 is not None:
            print(f"关键词出现次数: {次数}")
        else:
            print("无法读取文件或查找关键词")

    注意:
        - 此函数假设文本文件为 UTF-8 编码。如果文件是其他编码格式，可能会导致读取失败。
    """
    try:
        出现次数 = 0
        # 以读取模式打开文件，使用 UTF-8 编码
        with open(文件路径, 'r', encoding='utf-8') as 文件:
            for 行 in 文件:
                出现次数 += 行.count(关键词)
        return 出现次数
    except Exception:
        return None