def 取指定行内容_分割(文件路径, 行号, 分隔符):
    """
    获取指定文本文件中特定行的内容，并根据提供的分隔符分割该行的内容。

    参数:
        - 文件路径 (str): 要读取的文本文件路径，要求为 UTF-8 编码格式。
        - 行号 (int): 要获取内容的行号（从 1 开始计数）。
        - 分隔符 (str): 用于分割行内容的分隔符。

    返回值:
        - list: 成功时返回分割后的内容列表。若失败或行号无效时，返回 None。

    示例:
        行内容列表 = 取指定行内容_分割('示例.txt', 3, '----')
        if 行内容列表 is not None:
            print("行内容列表:", 行内容列表)
        else:
            print("获取行内容失败")

    注意:
        - 行号从 1 开始计数。如果行号小于 1 或超出文件行数范围，将返回 None。
        - 此函数假设文本文件为 UTF-8 编码。如果文件是其他编码格式，可能会导致读取失败。
        - 返回的列表元素会去除分割后每个部分中的行尾换行符和多余空格。
    """
    try:
        # 以读取模式打开文件，使用 UTF-8 编码
        with open(文件路径, 'r', encoding='utf-8') as file:
            行内容 = file.readlines()

        # 检查行号是否有效
        if 行号 < 1 or 行号 > len(行内容):
            return None

        # 获取指定行并去除行尾的换行符
        指定行内容 = 行内容[行号 - 1].rstrip('\n')

        # 根据分隔符分割行内容，并去除每个分割项的前后空格
        分割内容列表 = [item.strip() for item in 指定行内容.split(分隔符)]

        return 分割内容列表
    except Exception:
        return None