def 取指定行内容_取左边(文件路径, 行号, 分隔符):
    """
    获取指定文本文件中特定行的内容，并返回分隔符左边的部分。

    参数:
        - 文件路径 (str): 要读取的文本文件路径，要求为 UTF-8 编码格式。
        - 行号 (int): 要获取内容的行号（从 1 开始计数）。
        - 分隔符 (str): 用于定位行内容中分隔符的字符串。

    返回值:
        - str: 成功时返回分隔符左边的内容。若失败或未找到分隔符，返回 None。

    示例:
        行内容左边 = 取指定行内容_取左边('示例.txt', 3, '----')
        if 行内容左边 is not None:
            print("行内容左边:", 行内容左边)
        else:
            print("获取行内容失败")

    注意:
        - 行号从 1 开始计数。如果行号小于 1 或超出文件行数范围，将返回 None。
        - 此函数假设文本文件为 UTF-8 编码。如果文件是其他编码格式，可能会导致读取失败。
        - 如果未找到分隔符，返回 None。
    """
    try:
        # 以读取模式打开文件，使用 UTF-8 编码
        with open(文件路径, 'r', encoding='utf-8') as file:
            行内容 = file.readlines()

        # 检查行号是否有效
        if 行号 < 1 or 行号 > len(行内容):
            return None

        # 获取指定行并去除行尾的换行符
        指定行内容 = 行内容[行号 - 1].rstrip('\n')

        # 查找分隔符位置并获取分隔符左边的内容
        分隔符位置 = 指定行内容.find(分隔符)
        if 分隔符位置 == -1:
            return None

        # 返回分隔符左边的内容
        左边内容 = 指定行内容[:分隔符位置]

        return 左边内容
    except Exception:
        return None
