def 替换指定内容(文件路径, 旧内容, 新内容):
    """
    替换指定文本文件中的旧内容为新内容，并保存修改后的文件。文件编码格式必须为 UTF-8，否则可能导致读取或写入错误。

    参数:
        - 文件路径 (str): 要修改的文本文件路径，要求为 UTF-8 编码格式。
        - 旧内容 (str): 要被替换的内容。
        - 新内容 (str): 替换后的新内容。

    返回值:
        - bool: 如果替换成功返回 True，失败返回 False。

    示例:
        替换成功 = 替换指定内容('example.txt', '旧内容', '新内容')
        if 替换成功:
            print("内容替换成功")
        else:
            print("内容替换失败")

    注意:
        - 此函数假设文本文件为 UTF-8 编码。如果文件是其他编码格式，可能会导致读取或写入失败。
    """
    try:
        # 以读取模式打开文件，使用 UTF-8 编码
        with open(文件路径, 'r', encoding='utf-8') as 文件:
            文本 = 文件.read()

        # 替换文本内容
        替换后文本 = 文本.replace(旧内容, 新内容)

        # 以写入模式保存修改后的文本内容
        with open(文件路径, 'w', encoding='utf-8') as 文件:
            文件.write(替换后文本)

        return True
    except Exception:
        return False