def 重写内容(文件路径, 内容):
    """
    将指定内容写入指定文件路径的文本文件中，替换原本的内容。文件编码格式为 UTF-8。

    参数：
        - 文件路径：要写入的文本文件路径，要求为 UTF-8 编码格式。
        - 内容：要写入的新的文本内容，替换原文件内容。

    返回值：
        - bool：如果写入成功返回 True，失败返回 False。

    使用示例：
        写入结果 = 重写内容('文件路径.txt', '这是新的文件内容')

        # 将 '这是新的文件内容' 写入到指定文件，替换其原有内容。

    注意：
        - 此函数假设文件为 UTF-8 编码。如果文件是其他编码格式，可能会导致写入失败。
    """
    try:
        # 以写入模式打开文件，并使用 UTF-8 编码
        with open(文件路径, 'w', encoding='utf-8') as file:
            # 将新内容写入文件
            file.write(内容)

        return True
    except Exception:
        return False