def 响应对象_取中间(响应对象, 文本前缀, 文本后缀):
    """
    功能：
        从服务器响应对象的文本中，提取位于指定前缀和后缀之间的子字符串。
        如果找不到对应前缀或后缀，返回空字符串。

    参数：
        - 响应对象：
            requests.Response 类型对象，通常是 requests.get/post 返回值。
            若传入 None，则直接返回空字符串。
        - 文本前缀 (str)：
            定位目标文本起始位置的标记字符串。
        - 文本后缀 (str)：
            定位目标文本结束位置的标记字符串。

    返回：
        - str：
            提取到的目标子字符串。
        - str（空字符串）：
            当 响应对象 为 None、未找到前缀或后缀、或出现异常时，返回 ""。

    异常处理逻辑：
        - 如果 响应对象 为 None，立即返回空字符串。
        - 如果未找到前缀或后缀，返回空字符串。
        - 如果发生任何异常（如 .text 访问失败），返回空字符串。

    示例：
        >>> import requests
        >>> r = requests.get("https://httpbin.org/html")
        >>> 内容 = 响应对象_取中间(r, "<h1>", "</h1>")
        >>> print(内容)
        "Herman Melville - Moby-Dick"

    注意事项：
        - 本函数只会提取 **第一个匹配对**，不会处理多个相同前后缀的情况。
        - 返回的字符串不包含前缀和后缀本身。
        - 若要匹配多段内容，需要正则或循环处理。
    """
    try:
        if 响应对象 is None:
            return ''
        文本内容 = 响应对象.text
        起始位置 = 文本内容.find(文本前缀)
        if 起始位置 == -1:
            return ''
        起始位置 += len(文本前缀)
        结束位置 = 文本内容.find(文本后缀, 起始位置)
        if 结束位置 == -1:
            return ''
        return 文本内容[起始位置:结束位置]
    except Exception:
        return ''
