def 响应文本_取右边(响应文本, 目标文本):
    """
    功能：
        在响应文本（字符串）中查找第一次出现的目标文本，
        并返回其右边的所有内容。如果未找到目标文本，则返回空字符串。

    参数：
        - 响应文本 (str)：
            已经提取出来的字符串内容。
            如果传入 None，则直接返回空字符串。
        - 目标文本 (str)：
            用于定位的标记字符串。函数会截取该标记之后的所有内容。

    返回：
        - str：
            截取到的右边部分文本。
        - str（空字符串）：
            当 响应文本 为 None、未找到目标文本、或出现异常时，返回 ""。

    异常处理逻辑：
        - 如果 响应文本 为 None，立即返回空字符串。
        - 如果找不到目标文本，返回空字符串。
        - 如果切片过程中出错，也会返回空字符串。

    示例：
        >>> 内容 = "账号:admin 密码:123456"
        >>> 结果 = 响应文本_取右边(内容, "账号:")
        >>> print(结果)
        "admin 密码:123456"

    注意事项：
        - 仅处理 **第一次出现的目标文本**。
        - 返回结果不包含目标文本本身。
        - 若需多次截取，需要循环查找或使用正则。
    """
    try:
        if 响应文本 is None:
            return ''
        目标位置 = 响应文本.find(目标文本)
        if 目标位置 == -1:
            return ''
        return 响应文本[目标位置 + len(目标文本):]
    except Exception:
        return ''
