def 批量删除指定邮件(服务器对象, 删除数量):
    """
    批量删除指定数量的邮件，从第一封邮件开始依次删除。

    参数：
        - 服务器对象：已连接的 POP3 服务器对象，通常由 poplib.POP3 或 poplib.POP3_SSL 创建。
        - 删除数量：要删除的邮件数量，默认从邮箱中的第一封邮件开始。

    返回值：
        - int：成功删除的邮件数量。如果删除过程中发生异常，返回已成功删除的邮件数量。

    使用示例：
        连接对象 = zfx_pop3.连接服务器('pop.服务器.com', use_ssl=True)
        登录结果 = zfx_pop3.登录(连接对象, '用户名', '密码')
        成功删除数量 = zfx_pop3.批量删除指定邮件(连接对象, 5)

        print(f"成功删除 {成功删除数量} 封邮件")

    注意：
        - 邮件会在会话关闭后（例如调用 `zfx_pop3.断开连接(服务器对象)`）才会真正从服务器上删除。
        - 删除数量不能超过邮箱中的邮件总数，函数会自动处理这一情况。
        - 由于 POP3 的邮件索引从 1 开始，所以删除是从第一封邮件开始依次进行的。
    """
    成功删除数量 = 0
    try:
        # 获取邮箱中的总邮件数量
        总邮件数量, _ = 服务器对象.stat()

        # 确保删除数量不超过邮件总数
        删除数量 = min(删除数量, 总邮件数量)

        # 批量删除邮件
        for i in range(1, 删除数量 + 1):
            服务器对象.dele(i)
            成功删除数量 += 1

        return 成功删除数量
    except Exception:
        return 成功删除数量